<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tUnidad StructType
 * Meta information extracted from the WSDL
 * - documentation: Identificación de unidad ofertante o física
 * @subpackage Structs
 */
class TUnidad extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - pattern: (\p{Lu}|\p{N}|\p{Pd}|\p{Pc}|\p{Zs}|/){1,14}
     * - use: required
     * @var string
     */
    public $v;
    /**
     * The codMin
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - use: optional
     * @var string
     */
    public $codMin;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - documentation: Área de la unidad
     * - use: optional
     * @var string
     */
    public $area;
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - documentation: Tipo de unidad
     * - use: optional
     * @var string
     */
    public $tipo;
    /**
     * Constructor method for tUnidad
     * @uses TUnidad::setV()
     * @uses TUnidad::setCodMin()
     * @uses TUnidad::setArea()
     * @uses TUnidad::setTipo()
     * @param string $v
     * @param string $codMin
     * @param string $area
     * @param string $tipo
     */
    public function __construct($v = null, $codMin = null, $area = null, $tipo = null)
    {
        $this
            ->setV($v)
            ->setCodMin($codMin)
            ->setArea($area)
            ->setTipo($tipo);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param string $v
     * @return \StructType\TUnidad
     */
    public function setV($v = null)
    {
        // validation for constraint: string
        if (!is_null($v) && !is_string($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($v) && mb_strlen($v) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($v)), __LINE__);
        }
        // validation for constraint: pattern((\p{Lu}|\p{N}|\p{Pd}|\p{Pc}|\p{Zs}|/){1,14})
        if (!is_null($v) && !preg_match('/(\\p{Lu}|\\p{N}|\\p{Pd}|\\p{Pc}|\\p{Zs}|\/){1,14}/', $v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\p{Lu}|\p{N}|\p{Pd}|\p{Pc}|\p{Zs}|/){1,14}', var_export($v, true)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get codMin value
     * @return string|null
     */
    public function getCodMin()
    {
        return $this->codMin;
    }
    /**
     * Set codMin value
     * @param string $codMin
     * @return \StructType\TUnidad
     */
    public function setCodMin($codMin = null)
    {
        // validation for constraint: string
        if (!is_null($codMin) && !is_string($codMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codMin, true), gettype($codMin)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($codMin) && mb_strlen($codMin) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($codMin)), __LINE__);
        }
        $this->codMin = $codMin;
        return $this;
    }
    /**
     * Get area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @uses \EnumType\TAtrArea::valueIsValid()
     * @uses \EnumType\TAtrArea::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $area
     * @return \StructType\TUnidad
     */
    public function setArea($area = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrArea::valueIsValid($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrArea', is_array($area) ? implode(', ', $area) : var_export($area, true), implode(', ', \EnumType\TAtrArea::getValidValues())), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @uses \EnumType\TAtrTipoUnidad::valueIsValid()
     * @uses \EnumType\TAtrTipoUnidad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\TUnidad
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrTipoUnidad::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrTipoUnidad', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\TAtrTipoUnidad::getValidValues())), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TUnidad
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
