<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tSerieTemporalPrograma StructType
 * Meta information extracted from the WSDL
 * - documentation: Describe los datos de los planes individuales, uno por cada Unidad Ofertante y tipo de transacción, o por cada Unidad Física (según el intercambio).
 * @subpackage Structs
 */
class TSerieTemporalPrograma extends AbstractStructBase
{
    /**
     * The IdSerieTemporal
     * Meta information extracted from the WSDL
     * - documentation: Identificativo de la Serie, único por mensaje (se utilizará un valor secuencial por mensaje)
     * @var \StructType\TId
     */
    public $IdSerieTemporal;
    /**
     * The TipoTransac
     * Meta information extracted from the WSDL
     * - documentation: Tipo (Mercado, Bilateral, Régimen Especial a Distribución) y subtipo (Generación, Distribución, etc.) para identificar el tipo de transacción
     * @var \StructType\TTipoTransaccion
     */
    public $TipoTransac;
    /**
     * The IdTransaccion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdTransaccion
     */
    public $IdTransaccion;
    /**
     * The Agregacion
     * Meta information extracted from the WSDL
     * - documentation: Para identificar si se trata de Unidades Ofertantes o Físicas. Por defecto, Unidades Ofertantes (opcional)
     * - minOccurs: 0
     * @var \StructType\TAgregacion
     */
    public $Agregacion;
    /**
     * The IdUnidad
     * Meta information extracted from the WSDL
     * - documentation: Código de unidad ofertante o física. Incluye atributo con Código del Ministerio y Área donde se localiza.
     * @var \StructType\TUnidad
     */
    public $IdUnidad;
    /**
     * The IdGrupoEmpresarial
     * Meta information extracted from the WSDL
     * - documentation: Código de Grupo Empresarial, utilizado en programas desglosados por empresas, para identificar energías de la misma unidad pero diferente grupo empresarial
     * - minOccurs: 0
     * @var \StructType\TIdGrupoEmpresarial
     */
    public $IdGrupoEmpresarial;
    /**
     * The UniEnergia
     * Meta information extracted from the WSDL
     * - documentation: Por defecto "MWh"
     * - minOccurs: 0
     * @var \StructType\TUniEnergia
     */
    public $UniEnergia;
    /**
     * The Periodo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TPeriodoPrograma[]
     */
    public $Periodo;
    /**
     * Constructor method for tSerieTemporalPrograma
     * @uses TSerieTemporalPrograma::setIdSerieTemporal()
     * @uses TSerieTemporalPrograma::setTipoTransac()
     * @uses TSerieTemporalPrograma::setIdTransaccion()
     * @uses TSerieTemporalPrograma::setAgregacion()
     * @uses TSerieTemporalPrograma::setIdUnidad()
     * @uses TSerieTemporalPrograma::setIdGrupoEmpresarial()
     * @uses TSerieTemporalPrograma::setUniEnergia()
     * @uses TSerieTemporalPrograma::setPeriodo()
     * @param \StructType\TId $idSerieTemporal
     * @param \StructType\TTipoTransaccion $tipoTransac
     * @param \StructType\IdTransaccion $idTransaccion
     * @param \StructType\TAgregacion $agregacion
     * @param \StructType\TUnidad $idUnidad
     * @param \StructType\TIdGrupoEmpresarial $idGrupoEmpresarial
     * @param \StructType\TUniEnergia $uniEnergia
     * @param \StructType\TPeriodoPrograma[] $periodo
     */
    public function __construct(\StructType\TId $idSerieTemporal = null, \StructType\TTipoTransaccion $tipoTransac = null, \StructType\IdTransaccion $idTransaccion = null, \StructType\TAgregacion $agregacion = null, \StructType\TUnidad $idUnidad = null, \StructType\TIdGrupoEmpresarial $idGrupoEmpresarial = null, \StructType\TUniEnergia $uniEnergia = null, array $periodo = array())
    {
        $this
            ->setIdSerieTemporal($idSerieTemporal)
            ->setTipoTransac($tipoTransac)
            ->setIdTransaccion($idTransaccion)
            ->setAgregacion($agregacion)
            ->setIdUnidad($idUnidad)
            ->setIdGrupoEmpresarial($idGrupoEmpresarial)
            ->setUniEnergia($uniEnergia)
            ->setPeriodo($periodo);
    }
    /**
     * Get IdSerieTemporal value
     * @return \StructType\TId|null
     */
    public function getIdSerieTemporal()
    {
        return $this->IdSerieTemporal;
    }
    /**
     * Set IdSerieTemporal value
     * @param \StructType\TId $idSerieTemporal
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setIdSerieTemporal(\StructType\TId $idSerieTemporal = null)
    {
        $this->IdSerieTemporal = $idSerieTemporal;
        return $this;
    }
    /**
     * Get TipoTransac value
     * @return \StructType\TTipoTransaccion|null
     */
    public function getTipoTransac()
    {
        return $this->TipoTransac;
    }
    /**
     * Set TipoTransac value
     * @param \StructType\TTipoTransaccion $tipoTransac
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setTipoTransac(\StructType\TTipoTransaccion $tipoTransac = null)
    {
        $this->TipoTransac = $tipoTransac;
        return $this;
    }
    /**
     * Get IdTransaccion value
     * @return \StructType\IdTransaccion|null
     */
    public function getIdTransaccion()
    {
        return $this->IdTransaccion;
    }
    /**
     * Set IdTransaccion value
     * @param \StructType\IdTransaccion $idTransaccion
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setIdTransaccion(\StructType\IdTransaccion $idTransaccion = null)
    {
        $this->IdTransaccion = $idTransaccion;
        return $this;
    }
    /**
     * Get Agregacion value
     * @return \StructType\TAgregacion|null
     */
    public function getAgregacion()
    {
        return $this->Agregacion;
    }
    /**
     * Set Agregacion value
     * @param \StructType\TAgregacion $agregacion
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setAgregacion(\StructType\TAgregacion $agregacion = null)
    {
        $this->Agregacion = $agregacion;
        return $this;
    }
    /**
     * Get IdUnidad value
     * @return \StructType\TUnidad|null
     */
    public function getIdUnidad()
    {
        return $this->IdUnidad;
    }
    /**
     * Set IdUnidad value
     * @param \StructType\TUnidad $idUnidad
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setIdUnidad(\StructType\TUnidad $idUnidad = null)
    {
        $this->IdUnidad = $idUnidad;
        return $this;
    }
    /**
     * Get IdGrupoEmpresarial value
     * @return \StructType\TIdGrupoEmpresarial|null
     */
    public function getIdGrupoEmpresarial()
    {
        return $this->IdGrupoEmpresarial;
    }
    /**
     * Set IdGrupoEmpresarial value
     * @param \StructType\TIdGrupoEmpresarial $idGrupoEmpresarial
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setIdGrupoEmpresarial(\StructType\TIdGrupoEmpresarial $idGrupoEmpresarial = null)
    {
        $this->IdGrupoEmpresarial = $idGrupoEmpresarial;
        return $this;
    }
    /**
     * Get UniEnergia value
     * @return \StructType\TUniEnergia|null
     */
    public function getUniEnergia()
    {
        return $this->UniEnergia;
    }
    /**
     * Set UniEnergia value
     * @param \StructType\TUniEnergia $uniEnergia
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setUniEnergia(\StructType\TUniEnergia $uniEnergia = null)
    {
        $this->UniEnergia = $uniEnergia;
        return $this;
    }
    /**
     * Get Periodo value
     * @return \StructType\TPeriodoPrograma[]|null
     */
    public function getPeriodo()
    {
        return $this->Periodo;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodoForArrayConstraintsFromSetPeriodo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tSerieTemporalProgramaPeriodoItem) {
            // validation for constraint: itemType
            if (!$tSerieTemporalProgramaPeriodoItem instanceof \StructType\TPeriodoPrograma) {
                $invalidValues[] = is_object($tSerieTemporalProgramaPeriodoItem) ? get_class($tSerieTemporalProgramaPeriodoItem) : sprintf('%s(%s)', gettype($tSerieTemporalProgramaPeriodoItem), var_export($tSerieTemporalProgramaPeriodoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Periodo property can only contain items of type \StructType\TPeriodoPrograma, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoPrograma[] $periodo
     * @return \StructType\TSerieTemporalPrograma
     */
    public function setPeriodo(array $periodo = array())
    {
        // validation for constraint: array
        if ('' !== ($periodoArrayErrorMessage = self::validatePeriodoForArrayConstraintsFromSetPeriodo($periodo))) {
            throw new \InvalidArgumentException($periodoArrayErrorMessage, __LINE__);
        }
        $this->Periodo = $periodo;
        return $this;
    }
    /**
     * Add item to Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoPrograma $item
     * @return \StructType\TSerieTemporalPrograma
     */
    public function addToPeriodo(\StructType\TPeriodoPrograma $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TPeriodoPrograma) {
            throw new \InvalidArgumentException(sprintf('The Periodo property can only contain items of type \StructType\TPeriodoPrograma, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Periodo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TSerieTemporalPrograma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
