<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tSerieTemporalPrecios StructType
 * Meta information extracted from the WSDL
 * - documentation: Serie temporal
 * @subpackage Structs
 */
class TSerieTemporalPrecios extends AbstractStructBase
{
    /**
     * The IdSerieTemporal
     * Meta information extracted from the WSDL
     * - documentation: Identificativo de serie dentro del fichero.
     * @var \StructType\TId
     */
    public $IdSerieTemporal;
    /**
     * The IdArea
     * Meta information extracted from the WSDL
     * - documentation: Identificativo de Área a la que aplica el precio. En caso de no existir este elemento, se entiende que corresponde a la zona de España.
     * - minOccurs: 0
     * @var \StructType\TId
     */
    public $IdArea;
    /**
     * The UniPrecio
     * Meta information extracted from the WSDL
     * - documentation: Código "cEURO/kWh"
     * - minOccurs: 0
     * @var \StructType\TUniPrecio
     */
    public $UniPrecio;
    /**
     * The Periodo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TPeriodoPrecios[]
     */
    public $Periodo;
    /**
     * Constructor method for tSerieTemporalPrecios
     * @uses TSerieTemporalPrecios::setIdSerieTemporal()
     * @uses TSerieTemporalPrecios::setIdArea()
     * @uses TSerieTemporalPrecios::setUniPrecio()
     * @uses TSerieTemporalPrecios::setPeriodo()
     * @param \StructType\TId $idSerieTemporal
     * @param \StructType\TId $idArea
     * @param \StructType\TUniPrecio $uniPrecio
     * @param \StructType\TPeriodoPrecios[] $periodo
     */
    public function __construct(\StructType\TId $idSerieTemporal = null, \StructType\TId $idArea = null, \StructType\TUniPrecio $uniPrecio = null, array $periodo = array())
    {
        $this
            ->setIdSerieTemporal($idSerieTemporal)
            ->setIdArea($idArea)
            ->setUniPrecio($uniPrecio)
            ->setPeriodo($periodo);
    }
    /**
     * Get IdSerieTemporal value
     * @return \StructType\TId|null
     */
    public function getIdSerieTemporal()
    {
        return $this->IdSerieTemporal;
    }
    /**
     * Set IdSerieTemporal value
     * @param \StructType\TId $idSerieTemporal
     * @return \StructType\TSerieTemporalPrecios
     */
    public function setIdSerieTemporal(\StructType\TId $idSerieTemporal = null)
    {
        $this->IdSerieTemporal = $idSerieTemporal;
        return $this;
    }
    /**
     * Get IdArea value
     * @return \StructType\TId|null
     */
    public function getIdArea()
    {
        return $this->IdArea;
    }
    /**
     * Set IdArea value
     * @param \StructType\TId $idArea
     * @return \StructType\TSerieTemporalPrecios
     */
    public function setIdArea(\StructType\TId $idArea = null)
    {
        $this->IdArea = $idArea;
        return $this;
    }
    /**
     * Get UniPrecio value
     * @return \StructType\TUniPrecio|null
     */
    public function getUniPrecio()
    {
        return $this->UniPrecio;
    }
    /**
     * Set UniPrecio value
     * @param \StructType\TUniPrecio $uniPrecio
     * @return \StructType\TSerieTemporalPrecios
     */
    public function setUniPrecio(\StructType\TUniPrecio $uniPrecio = null)
    {
        $this->UniPrecio = $uniPrecio;
        return $this;
    }
    /**
     * Get Periodo value
     * @return \StructType\TPeriodoPrecios[]|null
     */
    public function getPeriodo()
    {
        return $this->Periodo;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodoForArrayConstraintsFromSetPeriodo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tSerieTemporalPreciosPeriodoItem) {
            // validation for constraint: itemType
            if (!$tSerieTemporalPreciosPeriodoItem instanceof \StructType\TPeriodoPrecios) {
                $invalidValues[] = is_object($tSerieTemporalPreciosPeriodoItem) ? get_class($tSerieTemporalPreciosPeriodoItem) : sprintf('%s(%s)', gettype($tSerieTemporalPreciosPeriodoItem), var_export($tSerieTemporalPreciosPeriodoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Periodo property can only contain items of type \StructType\TPeriodoPrecios, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoPrecios[] $periodo
     * @return \StructType\TSerieTemporalPrecios
     */
    public function setPeriodo(array $periodo = array())
    {
        // validation for constraint: array
        if ('' !== ($periodoArrayErrorMessage = self::validatePeriodoForArrayConstraintsFromSetPeriodo($periodo))) {
            throw new \InvalidArgumentException($periodoArrayErrorMessage, __LINE__);
        }
        $this->Periodo = $periodo;
        return $this;
    }
    /**
     * Add item to Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoPrecios $item
     * @return \StructType\TSerieTemporalPrecios
     */
    public function addToPeriodo(\StructType\TPeriodoPrecios $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TPeriodoPrecios) {
            throw new \InvalidArgumentException(sprintf('The Periodo property can only contain items of type \StructType\TPeriodoPrecios, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Periodo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TSerieTemporalPrecios
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
