<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tRespuesta StructType
 * Meta information extracted from the WSDL
 * - documentation: Código y texto de respuesta
 * @subpackage Structs
 */
class TRespuesta extends AbstractStructBase
{
    /**
     * The CodigoRespuesta
     * @var \StructType\CodigoRespuesta
     */
    public $CodigoRespuesta;
    /**
     * The TextoRespuesta
     * Meta information extracted from the WSDL
     * - documentation: Textos descriptivos de la respuesta
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TextoRespuesta;
    /**
     * Constructor method for tRespuesta
     * @uses TRespuesta::setCodigoRespuesta()
     * @uses TRespuesta::setTextoRespuesta()
     * @param \StructType\CodigoRespuesta $codigoRespuesta
     * @param string[] $textoRespuesta
     */
    public function __construct(\StructType\CodigoRespuesta $codigoRespuesta = null, array $textoRespuesta = array())
    {
        $this
            ->setCodigoRespuesta($codigoRespuesta)
            ->setTextoRespuesta($textoRespuesta);
    }
    /**
     * Get CodigoRespuesta value
     * @return \StructType\CodigoRespuesta|null
     */
    public function getCodigoRespuesta()
    {
        return $this->CodigoRespuesta;
    }
    /**
     * Set CodigoRespuesta value
     * @param \StructType\CodigoRespuesta $codigoRespuesta
     * @return \StructType\TRespuesta
     */
    public function setCodigoRespuesta(\StructType\CodigoRespuesta $codigoRespuesta = null)
    {
        $this->CodigoRespuesta = $codigoRespuesta;
        return $this;
    }
    /**
     * Get TextoRespuesta value
     * @return string[]|null
     */
    public function getTextoRespuesta()
    {
        return $this->TextoRespuesta;
    }
    /**
     * This method is responsible for validating the values passed to the setTextoRespuesta method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTextoRespuesta method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextoRespuestaForArrayConstraintsFromSetTextoRespuesta(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tRespuestaTextoRespuestaItem) {
            // validation for constraint: itemType
            if (!is_string($tRespuestaTextoRespuestaItem)) {
                $invalidValues[] = is_object($tRespuestaTextoRespuestaItem) ? get_class($tRespuestaTextoRespuestaItem) : sprintf('%s(%s)', gettype($tRespuestaTextoRespuestaItem), var_export($tRespuestaTextoRespuestaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TextoRespuesta property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TextoRespuesta value
     * @throws \InvalidArgumentException
     * @param string[] $textoRespuesta
     * @return \StructType\TRespuesta
     */
    public function setTextoRespuesta(array $textoRespuesta = array())
    {
        // validation for constraint: array
        if ('' !== ($textoRespuestaArrayErrorMessage = self::validateTextoRespuestaForArrayConstraintsFromSetTextoRespuesta($textoRespuesta))) {
            throw new \InvalidArgumentException($textoRespuestaArrayErrorMessage, __LINE__);
        }
        $this->TextoRespuesta = $textoRespuesta;
        return $this;
    }
    /**
     * Add item to TextoRespuesta value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TRespuesta
     */
    public function addToTextoRespuesta($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TextoRespuesta property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TextoRespuesta[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TRespuesta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
