<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tMensajePrecios StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo global para precios de casación
 * @subpackage Structs
 */
class TMensajePrecios extends AbstractStructBase
{
    /**
     * The IdMensaje
     * Meta information extracted from the WSDL
     * - documentation: Identificación del mensaje
     * @var \StructType\TId
     */
    public $IdMensaje;
    /**
     * The VerMensaje
     * Meta information extracted from the WSDL
     * - documentation: Versión del mensaje
     * @var \StructType\TVersionMensaje
     */
    public $VerMensaje;
    /**
     * The FechaMensaje
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de generación de los datos para el mensaje (no de envío del mensaje en sí)
     * @var \StructType\TFechaHora
     */
    public $FechaMensaje;
    /**
     * The IdRemitente
     * Meta information extracted from the WSDL
     * - documentation: Código del emisor que envía el mensaje (OM)
     * @var \StructType\TIdRemitente
     */
    public $IdRemitente;
    /**
     * The IdPrecio
     * @var \StructType\IdPrecio
     */
    public $IdPrecio;
    /**
     * The TipoMercado
     * Meta information extracted from the WSDL
     * - documentation: MD: Mercado DiarioMI: Mercado Intradiario
     * @var \StructType\TMercado
     */
    public $TipoMercado;
    /**
     * The Sesion
     * @var \StructType\Sesion
     */
    public $Sesion;
    /**
     * The SerieTemporal
     * Meta information extracted from the WSDL
     * - documentation: Series temporales para los precios de cada area
     * - maxOccurs: unbounded
     * @var \StructType\TSerieTemporalPrecios[]
     */
    public $SerieTemporal;
    /**
     * Constructor method for tMensajePrecios
     * @uses TMensajePrecios::setIdMensaje()
     * @uses TMensajePrecios::setVerMensaje()
     * @uses TMensajePrecios::setFechaMensaje()
     * @uses TMensajePrecios::setIdRemitente()
     * @uses TMensajePrecios::setIdPrecio()
     * @uses TMensajePrecios::setTipoMercado()
     * @uses TMensajePrecios::setSesion()
     * @uses TMensajePrecios::setSerieTemporal()
     * @param \StructType\TId $idMensaje
     * @param \StructType\TVersionMensaje $verMensaje
     * @param \StructType\TFechaHora $fechaMensaje
     * @param \StructType\TIdRemitente $idRemitente
     * @param \StructType\IdPrecio $idPrecio
     * @param \StructType\TMercado $tipoMercado
     * @param \StructType\Sesion $sesion
     * @param \StructType\TSerieTemporalPrecios[] $serieTemporal
     */
    public function __construct(\StructType\TId $idMensaje = null, \StructType\TVersionMensaje $verMensaje = null, \StructType\TFechaHora $fechaMensaje = null, \StructType\TIdRemitente $idRemitente = null, \StructType\IdPrecio $idPrecio = null, \StructType\TMercado $tipoMercado = null, \StructType\Sesion $sesion = null, array $serieTemporal = array())
    {
        $this
            ->setIdMensaje($idMensaje)
            ->setVerMensaje($verMensaje)
            ->setFechaMensaje($fechaMensaje)
            ->setIdRemitente($idRemitente)
            ->setIdPrecio($idPrecio)
            ->setTipoMercado($tipoMercado)
            ->setSesion($sesion)
            ->setSerieTemporal($serieTemporal);
    }
    /**
     * Get IdMensaje value
     * @return \StructType\TId|null
     */
    public function getIdMensaje()
    {
        return $this->IdMensaje;
    }
    /**
     * Set IdMensaje value
     * @param \StructType\TId $idMensaje
     * @return \StructType\TMensajePrecios
     */
    public function setIdMensaje(\StructType\TId $idMensaje = null)
    {
        $this->IdMensaje = $idMensaje;
        return $this;
    }
    /**
     * Get VerMensaje value
     * @return \StructType\TVersionMensaje|null
     */
    public function getVerMensaje()
    {
        return $this->VerMensaje;
    }
    /**
     * Set VerMensaje value
     * @param \StructType\TVersionMensaje $verMensaje
     * @return \StructType\TMensajePrecios
     */
    public function setVerMensaje(\StructType\TVersionMensaje $verMensaje = null)
    {
        $this->VerMensaje = $verMensaje;
        return $this;
    }
    /**
     * Get FechaMensaje value
     * @return \StructType\TFechaHora|null
     */
    public function getFechaMensaje()
    {
        return $this->FechaMensaje;
    }
    /**
     * Set FechaMensaje value
     * @param \StructType\TFechaHora $fechaMensaje
     * @return \StructType\TMensajePrecios
     */
    public function setFechaMensaje(\StructType\TFechaHora $fechaMensaje = null)
    {
        $this->FechaMensaje = $fechaMensaje;
        return $this;
    }
    /**
     * Get IdRemitente value
     * @return \StructType\TIdRemitente|null
     */
    public function getIdRemitente()
    {
        return $this->IdRemitente;
    }
    /**
     * Set IdRemitente value
     * @param \StructType\TIdRemitente $idRemitente
     * @return \StructType\TMensajePrecios
     */
    public function setIdRemitente(\StructType\TIdRemitente $idRemitente = null)
    {
        $this->IdRemitente = $idRemitente;
        return $this;
    }
    /**
     * Get IdPrecio value
     * @return \StructType\IdPrecio|null
     */
    public function getIdPrecio()
    {
        return $this->IdPrecio;
    }
    /**
     * Set IdPrecio value
     * @param \StructType\IdPrecio $idPrecio
     * @return \StructType\TMensajePrecios
     */
    public function setIdPrecio(\StructType\IdPrecio $idPrecio = null)
    {
        $this->IdPrecio = $idPrecio;
        return $this;
    }
    /**
     * Get TipoMercado value
     * @return \StructType\TMercado|null
     */
    public function getTipoMercado()
    {
        return $this->TipoMercado;
    }
    /**
     * Set TipoMercado value
     * @param \StructType\TMercado $tipoMercado
     * @return \StructType\TMensajePrecios
     */
    public function setTipoMercado(\StructType\TMercado $tipoMercado = null)
    {
        $this->TipoMercado = $tipoMercado;
        return $this;
    }
    /**
     * Get Sesion value
     * @return \StructType\Sesion|null
     */
    public function getSesion()
    {
        return $this->Sesion;
    }
    /**
     * Set Sesion value
     * @param \StructType\Sesion $sesion
     * @return \StructType\TMensajePrecios
     */
    public function setSesion(\StructType\Sesion $sesion = null)
    {
        $this->Sesion = $sesion;
        return $this;
    }
    /**
     * Get SerieTemporal value
     * @return \StructType\TSerieTemporalPrecios[]|null
     */
    public function getSerieTemporal()
    {
        return $this->SerieTemporal;
    }
    /**
     * This method is responsible for validating the values passed to the setSerieTemporal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerieTemporal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSerieTemporalForArrayConstraintsFromSetSerieTemporal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tMensajePreciosSerieTemporalItem) {
            // validation for constraint: itemType
            if (!$tMensajePreciosSerieTemporalItem instanceof \StructType\TSerieTemporalPrecios) {
                $invalidValues[] = is_object($tMensajePreciosSerieTemporalItem) ? get_class($tMensajePreciosSerieTemporalItem) : sprintf('%s(%s)', gettype($tMensajePreciosSerieTemporalItem), var_export($tMensajePreciosSerieTemporalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SerieTemporal property can only contain items of type \StructType\TSerieTemporalPrecios, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SerieTemporal value
     * @throws \InvalidArgumentException
     * @param \StructType\TSerieTemporalPrecios[] $serieTemporal
     * @return \StructType\TMensajePrecios
     */
    public function setSerieTemporal(array $serieTemporal = array())
    {
        // validation for constraint: array
        if ('' !== ($serieTemporalArrayErrorMessage = self::validateSerieTemporalForArrayConstraintsFromSetSerieTemporal($serieTemporal))) {
            throw new \InvalidArgumentException($serieTemporalArrayErrorMessage, __LINE__);
        }
        $this->SerieTemporal = $serieTemporal;
        return $this;
    }
    /**
     * Add item to SerieTemporal value
     * @throws \InvalidArgumentException
     * @param \StructType\TSerieTemporalPrecios $item
     * @return \StructType\TMensajePrecios
     */
    public function addToSerieTemporal(\StructType\TSerieTemporalPrecios $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TSerieTemporalPrecios) {
            throw new \InvalidArgumentException(sprintf('The SerieTemporal property can only contain items of type \StructType\TSerieTemporalPrecios, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SerieTemporal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TMensajePrecios
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
