<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tMensajeAnotaciones StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo global para Anotaciones
 * @subpackage Structs
 */
class TMensajeAnotaciones extends AbstractStructBase
{
    /**
     * The IdMensaje
     * Meta information extracted from the WSDL
     * - documentation: Identificativo del contenido del mensaje (por ejemplo "ANOTACIONES_LIQ_20080603")
     * @var \StructType\TId
     */
    public $IdMensaje;
    /**
     * The VerMensaje
     * Meta information extracted from the WSDL
     * - documentation: Versión del contenido del mensaje (para diferentes versiones de la misma liquidación)
     * @var \StructType\TVersionMensaje
     */
    public $VerMensaje;
    /**
     * The FechaMensaje
     * Meta information extracted from the WSDL
     * - documentation: Fecha/hora de generación de los datos en el servidor (no del envío del mensaje)
     * @var \StructType\TFechaHora
     */
    public $FechaMensaje;
    /**
     * The IdRemitente
     * Meta information extracted from the WSDL
     * - documentation: Código del remitente (OM)
     * @var \StructType\TIdRemitente
     */
    public $IdRemitente;
    /**
     * The Sesion
     * @var \StructType\Sesion
     */
    public $Sesion;
    /**
     * The Horizonte
     * Meta information extracted from the WSDL
     * - documentation: Intervalo temporal (ISO 8601) de validez del Programa
     * @var \StructType\TIntervaloTiempo
     */
    public $Horizonte;
    /**
     * The EstadoLiq
     * Meta information extracted from the WSDL
     * - documentation: Estado de la Liquidación
     * @var \StructType\TEstadoLiq
     */
    public $EstadoLiq;
    /**
     * The AnotacionesEmpresa
     * Meta information extracted from the WSDL
     * - documentation: Anotaciones de una empresa
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TAnotacionesEmpresa[]
     */
    public $AnotacionesEmpresa;
    /**
     * Constructor method for tMensajeAnotaciones
     * @uses TMensajeAnotaciones::setIdMensaje()
     * @uses TMensajeAnotaciones::setVerMensaje()
     * @uses TMensajeAnotaciones::setFechaMensaje()
     * @uses TMensajeAnotaciones::setIdRemitente()
     * @uses TMensajeAnotaciones::setSesion()
     * @uses TMensajeAnotaciones::setHorizonte()
     * @uses TMensajeAnotaciones::setEstadoLiq()
     * @uses TMensajeAnotaciones::setAnotacionesEmpresa()
     * @param \StructType\TId $idMensaje
     * @param \StructType\TVersionMensaje $verMensaje
     * @param \StructType\TFechaHora $fechaMensaje
     * @param \StructType\TIdRemitente $idRemitente
     * @param \StructType\Sesion $sesion
     * @param \StructType\TIntervaloTiempo $horizonte
     * @param \StructType\TEstadoLiq $estadoLiq
     * @param \StructType\TAnotacionesEmpresa[] $anotacionesEmpresa
     */
    public function __construct(\StructType\TId $idMensaje = null, \StructType\TVersionMensaje $verMensaje = null, \StructType\TFechaHora $fechaMensaje = null, \StructType\TIdRemitente $idRemitente = null, \StructType\Sesion $sesion = null, \StructType\TIntervaloTiempo $horizonte = null, \StructType\TEstadoLiq $estadoLiq = null, array $anotacionesEmpresa = array())
    {
        $this
            ->setIdMensaje($idMensaje)
            ->setVerMensaje($verMensaje)
            ->setFechaMensaje($fechaMensaje)
            ->setIdRemitente($idRemitente)
            ->setSesion($sesion)
            ->setHorizonte($horizonte)
            ->setEstadoLiq($estadoLiq)
            ->setAnotacionesEmpresa($anotacionesEmpresa);
    }
    /**
     * Get IdMensaje value
     * @return \StructType\TId|null
     */
    public function getIdMensaje()
    {
        return $this->IdMensaje;
    }
    /**
     * Set IdMensaje value
     * @param \StructType\TId $idMensaje
     * @return \StructType\TMensajeAnotaciones
     */
    public function setIdMensaje(\StructType\TId $idMensaje = null)
    {
        $this->IdMensaje = $idMensaje;
        return $this;
    }
    /**
     * Get VerMensaje value
     * @return \StructType\TVersionMensaje|null
     */
    public function getVerMensaje()
    {
        return $this->VerMensaje;
    }
    /**
     * Set VerMensaje value
     * @param \StructType\TVersionMensaje $verMensaje
     * @return \StructType\TMensajeAnotaciones
     */
    public function setVerMensaje(\StructType\TVersionMensaje $verMensaje = null)
    {
        $this->VerMensaje = $verMensaje;
        return $this;
    }
    /**
     * Get FechaMensaje value
     * @return \StructType\TFechaHora|null
     */
    public function getFechaMensaje()
    {
        return $this->FechaMensaje;
    }
    /**
     * Set FechaMensaje value
     * @param \StructType\TFechaHora $fechaMensaje
     * @return \StructType\TMensajeAnotaciones
     */
    public function setFechaMensaje(\StructType\TFechaHora $fechaMensaje = null)
    {
        $this->FechaMensaje = $fechaMensaje;
        return $this;
    }
    /**
     * Get IdRemitente value
     * @return \StructType\TIdRemitente|null
     */
    public function getIdRemitente()
    {
        return $this->IdRemitente;
    }
    /**
     * Set IdRemitente value
     * @param \StructType\TIdRemitente $idRemitente
     * @return \StructType\TMensajeAnotaciones
     */
    public function setIdRemitente(\StructType\TIdRemitente $idRemitente = null)
    {
        $this->IdRemitente = $idRemitente;
        return $this;
    }
    /**
     * Get Sesion value
     * @return \StructType\Sesion|null
     */
    public function getSesion()
    {
        return $this->Sesion;
    }
    /**
     * Set Sesion value
     * @param \StructType\Sesion $sesion
     * @return \StructType\TMensajeAnotaciones
     */
    public function setSesion(\StructType\Sesion $sesion = null)
    {
        $this->Sesion = $sesion;
        return $this;
    }
    /**
     * Get Horizonte value
     * @return \StructType\TIntervaloTiempo|null
     */
    public function getHorizonte()
    {
        return $this->Horizonte;
    }
    /**
     * Set Horizonte value
     * @param \StructType\TIntervaloTiempo $horizonte
     * @return \StructType\TMensajeAnotaciones
     */
    public function setHorizonte(\StructType\TIntervaloTiempo $horizonte = null)
    {
        $this->Horizonte = $horizonte;
        return $this;
    }
    /**
     * Get EstadoLiq value
     * @return \StructType\TEstadoLiq|null
     */
    public function getEstadoLiq()
    {
        return $this->EstadoLiq;
    }
    /**
     * Set EstadoLiq value
     * @param \StructType\TEstadoLiq $estadoLiq
     * @return \StructType\TMensajeAnotaciones
     */
    public function setEstadoLiq(\StructType\TEstadoLiq $estadoLiq = null)
    {
        $this->EstadoLiq = $estadoLiq;
        return $this;
    }
    /**
     * Get AnotacionesEmpresa value
     * @return \StructType\TAnotacionesEmpresa[]|null
     */
    public function getAnotacionesEmpresa()
    {
        return $this->AnotacionesEmpresa;
    }
    /**
     * This method is responsible for validating the values passed to the setAnotacionesEmpresa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnotacionesEmpresa method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnotacionesEmpresaForArrayConstraintsFromSetAnotacionesEmpresa(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tMensajeAnotacionesAnotacionesEmpresaItem) {
            // validation for constraint: itemType
            if (!$tMensajeAnotacionesAnotacionesEmpresaItem instanceof \StructType\TAnotacionesEmpresa) {
                $invalidValues[] = is_object($tMensajeAnotacionesAnotacionesEmpresaItem) ? get_class($tMensajeAnotacionesAnotacionesEmpresaItem) : sprintf('%s(%s)', gettype($tMensajeAnotacionesAnotacionesEmpresaItem), var_export($tMensajeAnotacionesAnotacionesEmpresaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnotacionesEmpresa property can only contain items of type \StructType\TAnotacionesEmpresa, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnotacionesEmpresa value
     * @throws \InvalidArgumentException
     * @param \StructType\TAnotacionesEmpresa[] $anotacionesEmpresa
     * @return \StructType\TMensajeAnotaciones
     */
    public function setAnotacionesEmpresa(array $anotacionesEmpresa = array())
    {
        // validation for constraint: array
        if ('' !== ($anotacionesEmpresaArrayErrorMessage = self::validateAnotacionesEmpresaForArrayConstraintsFromSetAnotacionesEmpresa($anotacionesEmpresa))) {
            throw new \InvalidArgumentException($anotacionesEmpresaArrayErrorMessage, __LINE__);
        }
        $this->AnotacionesEmpresa = $anotacionesEmpresa;
        return $this;
    }
    /**
     * Add item to AnotacionesEmpresa value
     * @throws \InvalidArgumentException
     * @param \StructType\TAnotacionesEmpresa $item
     * @return \StructType\TMensajeAnotaciones
     */
    public function addToAnotacionesEmpresa(\StructType\TAnotacionesEmpresa $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TAnotacionesEmpresa) {
            throw new \InvalidArgumentException(sprintf('The AnotacionesEmpresa property can only contain items of type \StructType\TAnotacionesEmpresa, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnotacionesEmpresa[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TMensajeAnotaciones
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
