<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tIntervaloTiempo StructType
 * Meta information extracted from the WSDL
 * - documentation: Intervalo de tiempo expresado por una fecha y hora inicial y otra final, en formato ISO 8601.
 * @subpackage Structs
 */
class TIntervaloTiempo extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: [2][0][0-1][0-9][\-][0-1][0-9][\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\+][0-2][0-9][:][0-6][0-9])[/][2][0][0-1][0-9][\-][0-1][0-9][\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\+][0-2][0-9][:][0-6][0-9])
     * - use: required
     * @var string
     */
    public $v;
    /**
     * Constructor method for tIntervaloTiempo
     * @uses TIntervaloTiempo::setV()
     * @param string $v
     */
    public function __construct($v = null)
    {
        $this
            ->setV($v);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param string $v
     * @return \StructType\TIntervaloTiempo
     */
    public function setV($v = null)
    {
        // validation for constraint: string
        if (!is_null($v) && !is_string($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: pattern([2][0][0-1][0-9][\-][0-1][0-9][\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\+][0-2][0-9][:][0-6][0-9])[/][2][0][0-1][0-9][\-][0-1][0-9][\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\+][0-2][0-9][:][0-6][0-9]))
        if (!is_null($v) && !preg_match('/[2][0][0-1][0-9][\\-][0-1][0-9][\\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\\+][0-2][0-9][:][0-6][0-9])[\/][2][0][0-1][0-9][\\-][0-1][0-9][\\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\\+][0-2][0-9][:][0-6][0-9])/', $v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [2][0][0-1][0-9][\-][0-1][0-9][\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\+][0-2][0-9][:][0-6][0-9])[/][2][0][0-1][0-9][\-][0-1][0-9][\-][0-3][0-9][T][0-2][0-9][:][0-6][0-9](Z|[\+][0-2][0-9][:][0-6][0-9])', var_export($v, true)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TIntervaloTiempo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
