<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tImporte StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo en el que se expresan los importes
 * @subpackage Structs
 */
class TImporte extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - totalDigits: 16
     * - use: required
     * @var float
     */
    public $v;
    /**
     * Constructor method for tImporte
     * @uses TImporte::setV()
     * @param float $v
     */
    public function __construct($v = null)
    {
        $this
            ->setV($v);
    }
    /**
     * Get v value
     * @return float
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param float $v
     * @return \StructType\TImporte
     */
    public function setV($v = null)
    {
        // validation for constraint: float
        if (!is_null($v) && !(is_float($v) || is_numeric($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($v) && mb_strlen(mb_substr($v, mb_strpos($v, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($v, true), mb_strlen(mb_substr($v, mb_strpos($v, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($v) && mb_strlen(preg_replace('/(\D)/', '', $v)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($v, true), mb_strlen(preg_replace('/(\D)/', '', $v))), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TImporte
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
