<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tIdPrograma StructType
 * Meta information extracted from the WSDL
 * - documentation: Identificativo de programa
 * @subpackage Structs
 */
class TIdPrograma extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - documentation: Identificativo del programa
     * - use: required
     * @var string
     */
    public $v;
    /**
     * The t
     * Meta information extracted from the WSDL
     * - documentation: Tipo de programa
     * - use: required
     * @var string
     */
    public $t;
    /**
     * The fuente
     * Meta information extracted from the WSDL
     * - documentation: Fuente que originó el programa
     * - use: required
     * @var string
     */
    public $fuente;
    /**
     * Constructor method for tIdPrograma
     * @uses TIdPrograma::setV()
     * @uses TIdPrograma::setT()
     * @uses TIdPrograma::setFuente()
     * @param string $v
     * @param string $t
     * @param string $fuente
     */
    public function __construct($v = null, $t = null, $fuente = null)
    {
        $this
            ->setV($v)
            ->setT($t)
            ->setFuente($fuente);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @uses \EnumType\TAtrIdPrograma::valueIsValid()
     * @uses \EnumType\TAtrIdPrograma::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $v
     * @return \StructType\TIdPrograma
     */
    public function setV($v = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrIdPrograma::valueIsValid($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrIdPrograma', is_array($v) ? implode(', ', $v) : var_export($v, true), implode(', ', \EnumType\TAtrIdPrograma::getValidValues())), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get t value
     * @return string
     */
    public function getT()
    {
        return $this->t;
    }
    /**
     * Set t value
     * @uses \EnumType\TAtrTipoPrograma::valueIsValid()
     * @uses \EnumType\TAtrTipoPrograma::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $t
     * @return \StructType\TIdPrograma
     */
    public function setT($t = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrTipoPrograma::valueIsValid($t)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrTipoPrograma', is_array($t) ? implode(', ', $t) : var_export($t, true), implode(', ', \EnumType\TAtrTipoPrograma::getValidValues())), __LINE__);
        }
        $this->t = $t;
        return $this;
    }
    /**
     * Get fuente value
     * @return string
     */
    public function getFuente()
    {
        return $this->fuente;
    }
    /**
     * Set fuente value
     * @uses \EnumType\TAtrFuente::valueIsValid()
     * @uses \EnumType\TAtrFuente::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fuente
     * @return \StructType\TIdPrograma
     */
    public function setFuente($fuente = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrFuente::valueIsValid($fuente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrFuente', is_array($fuente) ? implode(', ', $fuente) : var_export($fuente, true), implode(', ', \EnumType\TAtrFuente::getValidValues())), __LINE__);
        }
        $this->fuente = $fuente;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TIdPrograma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
