<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sesion StructType
 * Meta information extracted from the WSDL
 * - documentation: Incluye Fecha y Número de Sesión (este último para uso futuro) | Sesión | Incluye Fecha y Número de Sesión
 * @subpackage Structs
 */
class Sesion extends AbstractStructBase
{
    /**
     * The fecha
     * Meta information extracted from the WSDL
     * - documentation: Fecha de la sesión
     * - use: required
     * @var string
     */
    public $fecha;
    /**
     * The num
     * Meta information extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - maxInclusive: 25
     * - use: optional
     * @var int
     */
    public $num;
    /**
     * Constructor method for Sesion
     * @uses Sesion::setFecha()
     * @uses Sesion::setNum()
     * @param string $fecha
     * @param int $num
     */
    public function __construct($fecha = null, $num = null)
    {
        $this
            ->setFecha($fecha)
            ->setNum($num);
    }
    /**
     * Get fecha value
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }
    /**
     * Set fecha value
     * @param string $fecha
     * @return \StructType\Sesion
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        $this->fecha = $fecha;
        return $this;
    }
    /**
     * Get num value
     * @return int|null
     */
    public function getNum()
    {
        return $this->num;
    }
    /**
     * Set num value
     * @param int $num
     * @return \StructType\Sesion
     */
    public function setNum($num = null)
    {
        // validation for constraint: int
        if (!is_null($num) && !(is_int($num) || ctype_digit($num))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($num, true), gettype($num)), __LINE__);
        }
        // validation for constraint: maxInclusive(25)
        if (!is_null($num) && $num > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 25', var_export($num, true)), __LINE__);
        }
        $this->num = $num;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sesion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
