<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Num StructType
 * Meta information extracted from the WSDL
 * - documentation: Columna de tipo numérico | Parámetro de tipo numérico | Parámetro de tipo númerico | Agregado de tipo numérico
 * @subpackage Structs
 */
class Num extends AbstractStructBase
{
    /**
     * The n
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - use: required
     * @var string
     */
    public $n;
    /**
     * The v
     * Meta information extracted from the WSDL
     * - documentation: Valor
     * - use: required
     * @var float
     */
    public $v;
    /**
     * The desc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 90
     * - use: optional
     * @var string
     */
    public $desc;
    /**
     * The long
     * Meta information extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - maxInclusive: 999
     * - use: optional
     * @var int
     */
    public $long;
    /**
     * The agregado
     * Meta information extracted from the WSDL
     * - documentation: Agregado
     * - use: optional
     * @var string
     */
    public $agregado;
    /**
     * Constructor method for Num
     * @uses Num::setN()
     * @uses Num::setV()
     * @uses Num::setDesc()
     * @uses Num::setLong()
     * @uses Num::setAgregado()
     * @param string $n
     * @param float $v
     * @param string $desc
     * @param int $long
     * @param string $agregado
     */
    public function __construct($n = null, $v = null, $desc = null, $long = null, $agregado = null)
    {
        $this
            ->setN($n)
            ->setV($v)
            ->setDesc($desc)
            ->setLong($long)
            ->setAgregado($agregado);
    }
    /**
     * Get n value
     * @return string
     */
    public function getN()
    {
        return $this->n;
    }
    /**
     * Set n value
     * @param string $n
     * @return \StructType\Num
     */
    public function setN($n = null)
    {
        // validation for constraint: string
        if (!is_null($n) && !is_string($n)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($n, true), gettype($n)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($n) && mb_strlen($n) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($n)), __LINE__);
        }
        $this->n = $n;
        return $this;
    }
    /**
     * Get v value
     * @return float
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param float $v
     * @return \StructType\Num
     */
    public function setV($v = null)
    {
        // validation for constraint: float
        if (!is_null($v) && !(is_float($v) || is_numeric($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\Num
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($desc) && mb_strlen($desc) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get long value
     * @return int|null
     */
    public function getLong()
    {
        return $this->long;
    }
    /**
     * Set long value
     * @param int $long
     * @return \StructType\Num
     */
    public function setLong($long = null)
    {
        // validation for constraint: int
        if (!is_null($long) && !(is_int($long) || ctype_digit($long))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($long, true), gettype($long)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($long) && $long > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($long, true)), __LINE__);
        }
        $this->long = $long;
        return $this;
    }
    /**
     * Get agregado value
     * @return string|null
     */
    public function getAgregado()
    {
        return $this->agregado;
    }
    /**
     * Set agregado value
     * @uses \EnumType\TAtrSiNo::valueIsValid()
     * @uses \EnumType\TAtrSiNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $agregado
     * @return \StructType\Num
     */
    public function setAgregado($agregado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrSiNo::valueIsValid($agregado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrSiNo', is_array($agregado) ? implode(', ', $agregado) : var_export($agregado, true), implode(', ', \EnumType\TAtrSiNo::getValidValues())), __LINE__);
        }
        $this->agregado = $agregado;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Num
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
