<?php

namespace EnumType;

/**
 * This class stands for tAtrUniMonetaria EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para unidad monetaria
 * @subpackage Enumerations
 */
class TAtrUniMonetaria
{
    /**
     * Constant for value 'cEURO'
     * @return string 'cEURO'
     */
    const VALUE_C_EURO = 'cEURO';
    /**
     * Constant for value 'EURO'
     * @return string 'EURO'
     */
    const VALUE_EURO = 'EURO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_C_EURO
     * @uses self::VALUE_EURO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_C_EURO,
            self::VALUE_EURO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
