<?php

namespace EnumType;

/**
 * This class stands for tAtrTipoResponsableCostes EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para tipo de Agente responsable de los costes de un Contrato Bilateral
 * @subpackage Enumerations
 */
class TAtrTipoResponsableCostes
{
    /**
     * Constant for value 'V'
     * Meta information extracted from the WSDL
     * - documentation: Agente de Venta
     * @return string 'V'
     */
    const VALUE_V = 'V';
    /**
     * Constant for value 'C'
     * Meta information extracted from the WSDL
     * - documentation: Agente de Compra
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'A'
     * Meta information extracted from the WSDL
     * - documentation: Ambos
     * @return string 'A'
     */
    const VALUE_A = 'A';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_V
     * @uses self::VALUE_C
     * @uses self::VALUE_A
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_V,
            self::VALUE_C,
            self::VALUE_A,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
