<?php

namespace EnumType;

/**
 * This class stands for tAtrTipoPrograma EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para Tipo de Programa (A, I)
 * @subpackage Enumerations
 */
class TAtrTipoPrograma
{
    /**
     * Constant for value 'A'
     * Meta information extracted from the WSDL
     * - documentation: A: Acumulado
     * @return string 'A'
     */
    const VALUE_A = 'A';
    /**
     * Constant for value 'I'
     * Meta information extracted from the WSDL
     * - documentation: I: Incremental
     * @return string 'I'
     */
    const VALUE_I = 'I';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A
     * @uses self::VALUE_I
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A,
            self::VALUE_I,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
