<?php

namespace EnumType;

/**
 * This class stands for tAtrTipoDescarga EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para tipo de descarga
 * @subpackage Enumerations
 */
class TAtrTipoDescarga
{
    /**
     * Constant for value 'A'
     * Meta information extracted from the WSDL
     * - documentation: Descarga Automática
     * @return string 'A'
     */
    const VALUE_A = 'A';
    /**
     * Constant for value 'M'
     * Meta information extracted from the WSDL
     * - documentation: Descarga Manual
     * @return string 'M'
     */
    const VALUE_M = 'M';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A
     * @uses self::VALUE_M
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A,
            self::VALUE_M,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
