<?php

namespace EnumType;

/**
 * This class stands for tAtrFuente EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para fuente de un programa (OM, OS)
 * @subpackage Enumerations
 */
class TAtrFuente
{
    /**
     * Constant for value 'OM'
     * @return string 'OM'
     */
    const VALUE_OM = 'OM';
    /**
     * Constant for value 'OS'
     * @return string 'OS'
     */
    const VALUE_OS = 'OS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OM
     * @uses self::VALUE_OS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OM,
            self::VALUE_OS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
