<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Valor StructType
 * Meta information extracted from the WSDL
 * - documentation: Valor de selección, incluyendo código y descripción (opcional)
 * @subpackage Structs
 */
class Valor extends AbstractStructBase
{
    /**
     * The cod
     * Meta information extracted from the WSDL
     * - documentation: Código
     * - use: required
     * @var string
     */
    public $cod;
    /**
     * The desc
     * Meta information extracted from the WSDL
     * - documentation: Descripción
     * - use: optional
     * @var string
     */
    public $desc;
    /**
     * Constructor method for Valor
     * @uses Valor::setCod()
     * @uses Valor::setDesc()
     * @param string $cod
     * @param string $desc
     */
    public function __construct($cod = null, $desc = null)
    {
        $this
            ->setCod($cod)
            ->setDesc($desc);
    }
    /**
     * Get cod value
     * @return string
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param string $cod
     * @return \StructType\Valor
     */
    public function setCod($cod = null)
    {
        // validation for constraint: string
        if (!is_null($cod) && !is_string($cod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cod, true), gettype($cod)), __LINE__);
        }
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\Valor
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Valor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
