<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tamano StructType
 * Meta information extracted from the WSDL
 * - documentation: Tamaño del fichero, indicando unidades en Bytes
 * @subpackage Structs
 */
class Tamano extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - documentation: Valor
     * - use: required
     * @var int
     */
    public $v;
    /**
     * The unidad
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $unidad;
    /**
     * Constructor method for Tamano
     * @uses Tamano::setV()
     * @uses Tamano::setUnidad()
     * @param int $v
     * @param string $unidad
     */
    public function __construct($v = null, $unidad = null)
    {
        $this
            ->setV($v)
            ->setUnidad($unidad);
    }
    /**
     * Get v value
     * @return int
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param int $v
     * @return \StructType\Tamano
     */
    public function setV($v = null)
    {
        // validation for constraint: int
        if (!is_null($v) && !(is_int($v) || ctype_digit($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get unidad value
     * @return string|null
     */
    public function getUnidad()
    {
        return $this->unidad;
    }
    /**
     * Set unidad value
     * @param string $unidad
     * @return \StructType\Tamano
     */
    public function setUnidad($unidad = null)
    {
        // validation for constraint: string
        if (!is_null($unidad) && !is_string($unidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidad, true), gettype($unidad)), __LINE__);
        }
        $this->unidad = $unidad;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tamano
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
