<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tTerminoFijo StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo en el que se expresa el término fijo
 * @subpackage Structs
 */
class TTerminoFijo extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - totalDigits: 9
     * - use: required
     * @var int
     */
    public $v;
    /**
     * Constructor method for tTerminoFijo
     * @uses TTerminoFijo::setV()
     * @param int $v
     */
    public function __construct($v = null)
    {
        $this
            ->setV($v);
    }
    /**
     * Get v value
     * @return int
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param int $v
     * @return \StructType\TTerminoFijo
     */
    public function setV($v = null)
    {
        // validation for constraint: int
        if (!is_null($v) && !(is_int($v) || ctype_digit($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($v) && mb_strlen(preg_replace('/(\D)/', '', $v)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($v, true), mb_strlen(preg_replace('/(\D)/', '', $v))), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TTerminoFijo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
