<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tSerieTemporalAnotaciones StructType
 * Meta information extracted from the WSDL
 * - documentation: Describe las anotaciones de las unidades de una empresa
 * @subpackage Structs
 */
class TSerieTemporalAnotaciones extends AbstractStructBase
{
    /**
     * The IdSerieTemporal
     * Meta information extracted from the WSDL
     * - documentation: Identificativo de la Serie, único por mensaje (se utilizará un valor secuencial por mensaje)
     * @var \StructType\TId
     */
    public $IdSerieTemporal;
    /**
     * The IdUnidad
     * Meta information extracted from the WSDL
     * - documentation: Código de unidad ofertante o física. Incluye atributo con Código del Ministerio y Área donde se localiza.
     * - minOccurs: 0
     * @var \StructType\TUnidad
     */
    public $IdUnidad;
    /**
     * The CodProducto
     * Meta information extracted from the WSDL
     * - documentation: Código de Producto
     * - minOccurs: 0
     * @var \StructType\TCodProducto
     */
    public $CodProducto;
    /**
     * The TipoProducto
     * Meta information extracted from the WSDL
     * - documentation: Tipo de Producto
     * - minOccurs: 0
     * @var \StructType\TTipoProducto
     */
    public $TipoProducto;
    /**
     * The UniPrecio
     * Meta information extracted from the WSDL
     * - documentation: Por defecto "cEURO/MWh"
     * - minOccurs: 0
     * @var \StructType\TUniPrecio
     */
    public $UniPrecio;
    /**
     * The UniEnergia
     * Meta information extracted from the WSDL
     * - documentation: Por defecto "MWh"
     * - minOccurs: 0
     * @var \StructType\TUniEnergia
     */
    public $UniEnergia;
    /**
     * The UniImporte
     * Meta information extracted from the WSDL
     * - documentation: Por defecto "EURO"
     * - minOccurs: 0
     * @var \StructType\TUniMonetaria
     */
    public $UniImporte;
    /**
     * The TipoOferta
     * Meta information extracted from the WSDL
     * - documentation: Tipo de oferta C=Compra V=Venta Z=Instrumental
     * @var \StructType\TClaseOfertaAnotacion
     */
    public $TipoOferta;
    /**
     * The TipoUnidadLiq
     * Meta information extracted from the WSDL
     * - documentation: Código numérico de tipo de unidad a efectos de liquidación
     * - minOccurs: 0
     * @var \StructType\TTipoUnidadLiq
     */
    public $TipoUnidadLiq;
    /**
     * The Periodo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TPeriodoAnotaciones[]
     */
    public $Periodo;
    /**
     * Constructor method for tSerieTemporalAnotaciones
     * @uses TSerieTemporalAnotaciones::setIdSerieTemporal()
     * @uses TSerieTemporalAnotaciones::setIdUnidad()
     * @uses TSerieTemporalAnotaciones::setCodProducto()
     * @uses TSerieTemporalAnotaciones::setTipoProducto()
     * @uses TSerieTemporalAnotaciones::setUniPrecio()
     * @uses TSerieTemporalAnotaciones::setUniEnergia()
     * @uses TSerieTemporalAnotaciones::setUniImporte()
     * @uses TSerieTemporalAnotaciones::setTipoOferta()
     * @uses TSerieTemporalAnotaciones::setTipoUnidadLiq()
     * @uses TSerieTemporalAnotaciones::setPeriodo()
     * @param \StructType\TId $idSerieTemporal
     * @param \StructType\TUnidad $idUnidad
     * @param \StructType\TCodProducto $codProducto
     * @param \StructType\TTipoProducto $tipoProducto
     * @param \StructType\TUniPrecio $uniPrecio
     * @param \StructType\TUniEnergia $uniEnergia
     * @param \StructType\TUniMonetaria $uniImporte
     * @param \StructType\TClaseOfertaAnotacion $tipoOferta
     * @param \StructType\TTipoUnidadLiq $tipoUnidadLiq
     * @param \StructType\TPeriodoAnotaciones[] $periodo
     */
    public function __construct(\StructType\TId $idSerieTemporal = null, \StructType\TUnidad $idUnidad = null, \StructType\TCodProducto $codProducto = null, \StructType\TTipoProducto $tipoProducto = null, \StructType\TUniPrecio $uniPrecio = null, \StructType\TUniEnergia $uniEnergia = null, \StructType\TUniMonetaria $uniImporte = null, \StructType\TClaseOfertaAnotacion $tipoOferta = null, \StructType\TTipoUnidadLiq $tipoUnidadLiq = null, array $periodo = array())
    {
        $this
            ->setIdSerieTemporal($idSerieTemporal)
            ->setIdUnidad($idUnidad)
            ->setCodProducto($codProducto)
            ->setTipoProducto($tipoProducto)
            ->setUniPrecio($uniPrecio)
            ->setUniEnergia($uniEnergia)
            ->setUniImporte($uniImporte)
            ->setTipoOferta($tipoOferta)
            ->setTipoUnidadLiq($tipoUnidadLiq)
            ->setPeriodo($periodo);
    }
    /**
     * Get IdSerieTemporal value
     * @return \StructType\TId|null
     */
    public function getIdSerieTemporal()
    {
        return $this->IdSerieTemporal;
    }
    /**
     * Set IdSerieTemporal value
     * @param \StructType\TId $idSerieTemporal
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setIdSerieTemporal(\StructType\TId $idSerieTemporal = null)
    {
        $this->IdSerieTemporal = $idSerieTemporal;
        return $this;
    }
    /**
     * Get IdUnidad value
     * @return \StructType\TUnidad|null
     */
    public function getIdUnidad()
    {
        return $this->IdUnidad;
    }
    /**
     * Set IdUnidad value
     * @param \StructType\TUnidad $idUnidad
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setIdUnidad(\StructType\TUnidad $idUnidad = null)
    {
        $this->IdUnidad = $idUnidad;
        return $this;
    }
    /**
     * Get CodProducto value
     * @return \StructType\TCodProducto|null
     */
    public function getCodProducto()
    {
        return $this->CodProducto;
    }
    /**
     * Set CodProducto value
     * @param \StructType\TCodProducto $codProducto
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setCodProducto(\StructType\TCodProducto $codProducto = null)
    {
        $this->CodProducto = $codProducto;
        return $this;
    }
    /**
     * Get TipoProducto value
     * @return \StructType\TTipoProducto|null
     */
    public function getTipoProducto()
    {
        return $this->TipoProducto;
    }
    /**
     * Set TipoProducto value
     * @param \StructType\TTipoProducto $tipoProducto
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setTipoProducto(\StructType\TTipoProducto $tipoProducto = null)
    {
        $this->TipoProducto = $tipoProducto;
        return $this;
    }
    /**
     * Get UniPrecio value
     * @return \StructType\TUniPrecio|null
     */
    public function getUniPrecio()
    {
        return $this->UniPrecio;
    }
    /**
     * Set UniPrecio value
     * @param \StructType\TUniPrecio $uniPrecio
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setUniPrecio(\StructType\TUniPrecio $uniPrecio = null)
    {
        $this->UniPrecio = $uniPrecio;
        return $this;
    }
    /**
     * Get UniEnergia value
     * @return \StructType\TUniEnergia|null
     */
    public function getUniEnergia()
    {
        return $this->UniEnergia;
    }
    /**
     * Set UniEnergia value
     * @param \StructType\TUniEnergia $uniEnergia
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setUniEnergia(\StructType\TUniEnergia $uniEnergia = null)
    {
        $this->UniEnergia = $uniEnergia;
        return $this;
    }
    /**
     * Get UniImporte value
     * @return \StructType\TUniMonetaria|null
     */
    public function getUniImporte()
    {
        return $this->UniImporte;
    }
    /**
     * Set UniImporte value
     * @param \StructType\TUniMonetaria $uniImporte
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setUniImporte(\StructType\TUniMonetaria $uniImporte = null)
    {
        $this->UniImporte = $uniImporte;
        return $this;
    }
    /**
     * Get TipoOferta value
     * @return \StructType\TClaseOfertaAnotacion|null
     */
    public function getTipoOferta()
    {
        return $this->TipoOferta;
    }
    /**
     * Set TipoOferta value
     * @param \StructType\TClaseOfertaAnotacion $tipoOferta
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setTipoOferta(\StructType\TClaseOfertaAnotacion $tipoOferta = null)
    {
        $this->TipoOferta = $tipoOferta;
        return $this;
    }
    /**
     * Get TipoUnidadLiq value
     * @return \StructType\TTipoUnidadLiq|null
     */
    public function getTipoUnidadLiq()
    {
        return $this->TipoUnidadLiq;
    }
    /**
     * Set TipoUnidadLiq value
     * @param \StructType\TTipoUnidadLiq $tipoUnidadLiq
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setTipoUnidadLiq(\StructType\TTipoUnidadLiq $tipoUnidadLiq = null)
    {
        $this->TipoUnidadLiq = $tipoUnidadLiq;
        return $this;
    }
    /**
     * Get Periodo value
     * @return \StructType\TPeriodoAnotaciones[]|null
     */
    public function getPeriodo()
    {
        return $this->Periodo;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodoForArrayConstraintsFromSetPeriodo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tSerieTemporalAnotacionesPeriodoItem) {
            // validation for constraint: itemType
            if (!$tSerieTemporalAnotacionesPeriodoItem instanceof \StructType\TPeriodoAnotaciones) {
                $invalidValues[] = is_object($tSerieTemporalAnotacionesPeriodoItem) ? get_class($tSerieTemporalAnotacionesPeriodoItem) : sprintf('%s(%s)', gettype($tSerieTemporalAnotacionesPeriodoItem), var_export($tSerieTemporalAnotacionesPeriodoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Periodo property can only contain items of type \StructType\TPeriodoAnotaciones, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoAnotaciones[] $periodo
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function setPeriodo(array $periodo = array())
    {
        // validation for constraint: array
        if ('' !== ($periodoArrayErrorMessage = self::validatePeriodoForArrayConstraintsFromSetPeriodo($periodo))) {
            throw new \InvalidArgumentException($periodoArrayErrorMessage, __LINE__);
        }
        $this->Periodo = $periodo;
        return $this;
    }
    /**
     * Add item to Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoAnotaciones $item
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public function addToPeriodo(\StructType\TPeriodoAnotaciones $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TPeriodoAnotaciones) {
            throw new \InvalidArgumentException(sprintf('The Periodo property can only contain items of type \StructType\TPeriodoAnotaciones, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Periodo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TSerieTemporalAnotaciones
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
