<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tPrecioNegativo StructType
 * Meta information extracted from the WSDL
 * - documentation: Precio negativo
 * @subpackage Structs
 */
class TPrecioNegativo extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxInclusive: 99999.999
     * - minInclusive: -99999.999
     * - totalDigits: 8
     * - use: required
     * @var float
     */
    public $v;
    /**
     * Constructor method for tPrecioNegativo
     * @uses TPrecioNegativo::setV()
     * @param float $v
     */
    public function __construct($v = null)
    {
        $this
            ->setV($v);
    }
    /**
     * Get v value
     * @return float
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param float $v
     * @return \StructType\TPrecioNegativo
     */
    public function setV($v = null)
    {
        // validation for constraint: float
        if (!is_null($v) && !(is_float($v) || is_numeric($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($v) && mb_strlen(mb_substr($v, mb_strpos($v, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($v, true), mb_strlen(mb_substr($v, mb_strpos($v, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.999)
        if (!is_null($v) && $v > 99999.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.999', var_export($v, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-99999.999)
        if (!is_null($v) && $v < -99999.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -99999.999', var_export($v, true)), __LINE__);
        }
        // validation for constraint: totalDigits(8)
        if (!is_null($v) && mb_strlen(preg_replace('/(\D)/', '', $v)) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 8 digits, "%d" given', var_export($v, true), mb_strlen(preg_replace('/(\D)/', '', $v))), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TPrecioNegativo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
