<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tNudo StructType
 * Meta information extracted from the WSDL
 * - documentation: Identificación de Nudo físico de la red
 * @subpackage Structs
 */
class TNudo extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 7
     * - use: required
     * @var string
     */
    public $v;
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - documentation: Tipo de nudo
     * - use: required
     * @var string
     */
    public $tipo;
    /**
     * Constructor method for tNudo
     * @uses TNudo::setV()
     * @uses TNudo::setTipo()
     * @param string $v
     * @param string $tipo
     */
    public function __construct($v = null, $tipo = null)
    {
        $this
            ->setV($v)
            ->setTipo($tipo);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param string $v
     * @return \StructType\TNudo
     */
    public function setV($v = null)
    {
        // validation for constraint: string
        if (!is_null($v) && !is_string($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: maxLength(7)
        if (!is_null($v) && mb_strlen($v) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 7', mb_strlen($v)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get tipo value
     * @return string
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @uses \EnumType\TAtrTipoNudo::valueIsValid()
     * @uses \EnumType\TAtrTipoNudo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\TNudo
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrTipoNudo::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrTipoNudo', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\TAtrTipoNudo::getValidValues())), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TNudo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
