<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tMensajeProgramas StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo global para Programas de operación de diferentes tipos
 * @subpackage Structs
 */
class TMensajeProgramas extends AbstractStructBase
{
    /**
     * The IdMensaje
     * Meta information extracted from the WSDL
     * - documentation: Identificativo del contenido del mensaje (por ejemplo "PDBF_20010603" "PDBF_IBEG_20010603" "PIBCA_2001060301")
     * @var \StructType\TId
     */
    public $IdMensaje;
    /**
     * The VerMensaje
     * Meta information extracted from the WSDL
     * - documentation: Versión del contenido del mensaje (para diferentes versiones del mismo programa)
     * @var \StructType\TVersionMensaje
     */
    public $VerMensaje;
    /**
     * The FechaMensaje
     * Meta information extracted from the WSDL
     * - documentation: Fecha/hora de generación de los datos en el servidor (no del envío del mensaje)
     * @var \StructType\TFechaHora
     */
    public $FechaMensaje;
    /**
     * The IdPrograma
     * Meta information extracted from the WSDL
     * - documentation: Identificación del programa, incluyendo un código (PDBC, PDVD, etc.), un tipo (Acumulado o Incremental) y la fuente (OM, OS).
     * @var \StructType\TIdPrograma
     */
    public $IdPrograma;
    /**
     * The IdRemitente
     * Meta information extracted from the WSDL
     * - documentation: Código del OM u OS, que envía el programa.
     * @var \StructType\TIdRemitente
     */
    public $IdRemitente;
    /**
     * The TipoMercado
     * Meta information extracted from the WSDL
     * - documentation: "MD": Diario "MI": Intradiario
     * @var \StructType\TMercado
     */
    public $TipoMercado;
    /**
     * The Sesion
     * @var \StructType\Sesion
     */
    public $Sesion;
    /**
     * The Horizonte
     * Meta information extracted from the WSDL
     * - documentation: Intervalo temporal (ISO 8601) de validez del Programa
     * @var \StructType\TIntervaloTiempo
     */
    public $Horizonte;
    /**
     * The SerieTemporal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TSerieTemporalPrograma[]
     */
    public $SerieTemporal;
    /**
     * Constructor method for tMensajeProgramas
     * @uses TMensajeProgramas::setIdMensaje()
     * @uses TMensajeProgramas::setVerMensaje()
     * @uses TMensajeProgramas::setFechaMensaje()
     * @uses TMensajeProgramas::setIdPrograma()
     * @uses TMensajeProgramas::setIdRemitente()
     * @uses TMensajeProgramas::setTipoMercado()
     * @uses TMensajeProgramas::setSesion()
     * @uses TMensajeProgramas::setHorizonte()
     * @uses TMensajeProgramas::setSerieTemporal()
     * @param \StructType\TId $idMensaje
     * @param \StructType\TVersionMensaje $verMensaje
     * @param \StructType\TFechaHora $fechaMensaje
     * @param \StructType\TIdPrograma $idPrograma
     * @param \StructType\TIdRemitente $idRemitente
     * @param \StructType\TMercado $tipoMercado
     * @param \StructType\Sesion $sesion
     * @param \StructType\TIntervaloTiempo $horizonte
     * @param \StructType\TSerieTemporalPrograma[] $serieTemporal
     */
    public function __construct(\StructType\TId $idMensaje = null, \StructType\TVersionMensaje $verMensaje = null, \StructType\TFechaHora $fechaMensaje = null, \StructType\TIdPrograma $idPrograma = null, \StructType\TIdRemitente $idRemitente = null, \StructType\TMercado $tipoMercado = null, \StructType\Sesion $sesion = null, \StructType\TIntervaloTiempo $horizonte = null, array $serieTemporal = array())
    {
        $this
            ->setIdMensaje($idMensaje)
            ->setVerMensaje($verMensaje)
            ->setFechaMensaje($fechaMensaje)
            ->setIdPrograma($idPrograma)
            ->setIdRemitente($idRemitente)
            ->setTipoMercado($tipoMercado)
            ->setSesion($sesion)
            ->setHorizonte($horizonte)
            ->setSerieTemporal($serieTemporal);
    }
    /**
     * Get IdMensaje value
     * @return \StructType\TId|null
     */
    public function getIdMensaje()
    {
        return $this->IdMensaje;
    }
    /**
     * Set IdMensaje value
     * @param \StructType\TId $idMensaje
     * @return \StructType\TMensajeProgramas
     */
    public function setIdMensaje(\StructType\TId $idMensaje = null)
    {
        $this->IdMensaje = $idMensaje;
        return $this;
    }
    /**
     * Get VerMensaje value
     * @return \StructType\TVersionMensaje|null
     */
    public function getVerMensaje()
    {
        return $this->VerMensaje;
    }
    /**
     * Set VerMensaje value
     * @param \StructType\TVersionMensaje $verMensaje
     * @return \StructType\TMensajeProgramas
     */
    public function setVerMensaje(\StructType\TVersionMensaje $verMensaje = null)
    {
        $this->VerMensaje = $verMensaje;
        return $this;
    }
    /**
     * Get FechaMensaje value
     * @return \StructType\TFechaHora|null
     */
    public function getFechaMensaje()
    {
        return $this->FechaMensaje;
    }
    /**
     * Set FechaMensaje value
     * @param \StructType\TFechaHora $fechaMensaje
     * @return \StructType\TMensajeProgramas
     */
    public function setFechaMensaje(\StructType\TFechaHora $fechaMensaje = null)
    {
        $this->FechaMensaje = $fechaMensaje;
        return $this;
    }
    /**
     * Get IdPrograma value
     * @return \StructType\TIdPrograma|null
     */
    public function getIdPrograma()
    {
        return $this->IdPrograma;
    }
    /**
     * Set IdPrograma value
     * @param \StructType\TIdPrograma $idPrograma
     * @return \StructType\TMensajeProgramas
     */
    public function setIdPrograma(\StructType\TIdPrograma $idPrograma = null)
    {
        $this->IdPrograma = $idPrograma;
        return $this;
    }
    /**
     * Get IdRemitente value
     * @return \StructType\TIdRemitente|null
     */
    public function getIdRemitente()
    {
        return $this->IdRemitente;
    }
    /**
     * Set IdRemitente value
     * @param \StructType\TIdRemitente $idRemitente
     * @return \StructType\TMensajeProgramas
     */
    public function setIdRemitente(\StructType\TIdRemitente $idRemitente = null)
    {
        $this->IdRemitente = $idRemitente;
        return $this;
    }
    /**
     * Get TipoMercado value
     * @return \StructType\TMercado|null
     */
    public function getTipoMercado()
    {
        return $this->TipoMercado;
    }
    /**
     * Set TipoMercado value
     * @param \StructType\TMercado $tipoMercado
     * @return \StructType\TMensajeProgramas
     */
    public function setTipoMercado(\StructType\TMercado $tipoMercado = null)
    {
        $this->TipoMercado = $tipoMercado;
        return $this;
    }
    /**
     * Get Sesion value
     * @return \StructType\Sesion|null
     */
    public function getSesion()
    {
        return $this->Sesion;
    }
    /**
     * Set Sesion value
     * @param \StructType\Sesion $sesion
     * @return \StructType\TMensajeProgramas
     */
    public function setSesion(\StructType\Sesion $sesion = null)
    {
        $this->Sesion = $sesion;
        return $this;
    }
    /**
     * Get Horizonte value
     * @return \StructType\TIntervaloTiempo|null
     */
    public function getHorizonte()
    {
        return $this->Horizonte;
    }
    /**
     * Set Horizonte value
     * @param \StructType\TIntervaloTiempo $horizonte
     * @return \StructType\TMensajeProgramas
     */
    public function setHorizonte(\StructType\TIntervaloTiempo $horizonte = null)
    {
        $this->Horizonte = $horizonte;
        return $this;
    }
    /**
     * Get SerieTemporal value
     * @return \StructType\TSerieTemporalPrograma[]|null
     */
    public function getSerieTemporal()
    {
        return $this->SerieTemporal;
    }
    /**
     * This method is responsible for validating the values passed to the setSerieTemporal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerieTemporal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSerieTemporalForArrayConstraintsFromSetSerieTemporal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tMensajeProgramasSerieTemporalItem) {
            // validation for constraint: itemType
            if (!$tMensajeProgramasSerieTemporalItem instanceof \StructType\TSerieTemporalPrograma) {
                $invalidValues[] = is_object($tMensajeProgramasSerieTemporalItem) ? get_class($tMensajeProgramasSerieTemporalItem) : sprintf('%s(%s)', gettype($tMensajeProgramasSerieTemporalItem), var_export($tMensajeProgramasSerieTemporalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SerieTemporal property can only contain items of type \StructType\TSerieTemporalPrograma, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SerieTemporal value
     * @throws \InvalidArgumentException
     * @param \StructType\TSerieTemporalPrograma[] $serieTemporal
     * @return \StructType\TMensajeProgramas
     */
    public function setSerieTemporal(array $serieTemporal = array())
    {
        // validation for constraint: array
        if ('' !== ($serieTemporalArrayErrorMessage = self::validateSerieTemporalForArrayConstraintsFromSetSerieTemporal($serieTemporal))) {
            throw new \InvalidArgumentException($serieTemporalArrayErrorMessage, __LINE__);
        }
        $this->SerieTemporal = $serieTemporal;
        return $this;
    }
    /**
     * Add item to SerieTemporal value
     * @throws \InvalidArgumentException
     * @param \StructType\TSerieTemporalPrograma $item
     * @return \StructType\TMensajeProgramas
     */
    public function addToSerieTemporal(\StructType\TSerieTemporalPrograma $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TSerieTemporalPrograma) {
            throw new \InvalidArgumentException(sprintf('The SerieTemporal property can only contain items of type \StructType\TSerieTemporalPrograma, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SerieTemporal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TMensajeProgramas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
