<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ses StructType
 * Meta information extracted from the WSDL
 * - documentation: Parámetro de tipo sesión de intradiario | Parámetro de tipo Sesión de Intradiario
 * @subpackage Structs
 */
class Ses extends AbstractStructBase
{
    /**
     * The n
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - use: required
     * @var string
     */
    public $n;
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - maxInclusive: 25
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $v;
    /**
     * The desc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 90
     * - use: optional
     * @var string
     */
    public $desc;
    /**
     * Constructor method for Ses
     * @uses Ses::setN()
     * @uses Ses::setV()
     * @uses Ses::setDesc()
     * @param string $n
     * @param int $v
     * @param string $desc
     */
    public function __construct($n = null, $v = null, $desc = null)
    {
        $this
            ->setN($n)
            ->setV($v)
            ->setDesc($desc);
    }
    /**
     * Get n value
     * @return string
     */
    public function getN()
    {
        return $this->n;
    }
    /**
     * Set n value
     * @param string $n
     * @return \StructType\Ses
     */
    public function setN($n = null)
    {
        // validation for constraint: string
        if (!is_null($n) && !is_string($n)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($n, true), gettype($n)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($n) && mb_strlen($n) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($n)), __LINE__);
        }
        $this->n = $n;
        return $this;
    }
    /**
     * Get v value
     * @return int
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param int $v
     * @return \StructType\Ses
     */
    public function setV($v = null)
    {
        // validation for constraint: int
        if (!is_null($v) && !(is_int($v) || ctype_digit($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: maxInclusive(25)
        if (!is_null($v) && $v > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 25', var_export($v, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($v) && $v < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($v, true)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\Ses
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($desc) && mb_strlen($desc) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
