<?php

namespace EnumType;

/**
 * This class stands for tAtrTipoUnidad EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para tipo de unidad (UO, UF, RE, CP)
 * @subpackage Enumerations
 */
class TAtrTipoUnidad
{
    /**
     * Constant for value 'UO'
     * Meta information extracted from the WSDL
     * - documentation: UO: Unidad Ofertante
     * @return string 'UO'
     */
    const VALUE_UO = 'UO';
    /**
     * Constant for value 'UF'
     * Meta information extracted from the WSDL
     * - documentation: UF:Unidad Física
     * @return string 'UF'
     */
    const VALUE_UF = 'UF';
    /**
     * Constant for value 'RE'
     * Meta information extracted from the WSDL
     * - documentation: RE:Régimen Especial
     * @return string 'RE'
     */
    const VALUE_RE = 'RE';
    /**
     * Constant for value 'CP'
     * Meta information extracted from the WSDL
     * - documentation: CP: Unidad de Contratación a Plazo
     * @return string 'CP'
     */
    const VALUE_CP = 'CP';
    /**
     * Constant for value 'UP'
     * Meta information extracted from the WSDL
     * - documentation: UP: Unidad de programación
     * @return string 'UP'
     */
    const VALUE_UP = 'UP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UO
     * @uses self::VALUE_UF
     * @uses self::VALUE_RE
     * @uses self::VALUE_CP
     * @uses self::VALUE_UP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UO,
            self::VALUE_UF,
            self::VALUE_RE,
            self::VALUE_CP,
            self::VALUE_UP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
