<?php

namespace EnumType;

/**
 * This class stands for tAtrTipoTransaccion EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para tipo de transacción
 * @subpackage Enumerations
 */
class TAtrTipoTransaccion
{
    /**
     * Constant for value 'M'
     * Meta information extracted from the WSDL
     * - documentation: M: Mercado
     * @return string 'M'
     */
    const VALUE_M = 'M';
    /**
     * Constant for value 'B'
     * Meta information extracted from the WSDL
     * - documentation: B: Bilateral
     * @return string 'B'
     */
    const VALUE_B = 'B';
    /**
     * Constant for value 'R'
     * Meta information extracted from the WSDL
     * - documentation: R: Régimen Especial
     * @return string 'R'
     */
    const VALUE_R = 'R';
    /**
     * Constant for value 'RM'
     * Meta information extracted from the WSDL
     * - documentation: RM: Redespachos al Mercado
     * @return string 'RM'
     */
    const VALUE_RM = 'RM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_M
     * @uses self::VALUE_B
     * @uses self::VALUE_R
     * @uses self::VALUE_RM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_M,
            self::VALUE_B,
            self::VALUE_R,
            self::VALUE_RM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
