<?php

namespace EnumType;

/**
 * This class stands for tAtrSiNo EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo pare elemento "booleano" (S, Y, N)
 * @subpackage Enumerations
 */
class TAtrSiNo
{
    /**
     * Constant for value 'S'
     * Meta information extracted from the WSDL
     * - documentation: S: Si
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'Y'
     * Meta information extracted from the WSDL
     * - documentation: Y: Si (yes)
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'N'
     * Meta information extracted from the WSDL
     * - documentation: N: No
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_S
     * @uses self::VALUE_Y
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_S,
            self::VALUE_Y,
            self::VALUE_N,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
