<?php

namespace EnumType;

/**
 * This class stands for tAtrEstadoLiq EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para estado de una liquidación (P, D)
 * @subpackage Enumerations
 */
class TAtrEstadoLiq
{
    /**
     * Constant for value 'P'
     * Meta information extracted from the WSDL
     * - documentation: P: Provisional
     * @return string 'P'
     */
    const VALUE_P = 'P';
    /**
     * Constant for value 'D'
     * Meta information extracted from the WSDL
     * - documentation: D: Definitiva
     * @return string 'D'
     */
    const VALUE_D = 'D';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_P
     * @uses self::VALUE_D
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_P,
            self::VALUE_D,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
