<?php

namespace EnumType;

/**
 * This class stands for tAtrClaseOfertaAnotacion EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para clase de oferta de una anotación (C, V, Z)
 * @subpackage Enumerations
 */
class TAtrClaseOfertaAnotacion
{
    /**
     * Constant for value 'C'
     * Meta information extracted from the WSDL
     * - documentation: C: Compra
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'V'
     * Meta information extracted from the WSDL
     * - documentation: V: Venta
     * @return string 'V'
     */
    const VALUE_V = 'V';
    /**
     * Constant for value 'Z'
     * Meta information extracted from the WSDL
     * - documentation: Z: Instrumental
     * @return string 'Z'
     */
    const VALUE_Z = 'Z';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_C
     * @uses self::VALUE_V
     * @uses self::VALUE_Z
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_C,
            self::VALUE_V,
            self::VALUE_Z,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
