<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Servicio ServiceType
 */
$servicio = new \ServiceType\Servicio($options);
/**
 * Sample call for ServicioConsultaDirectorioConsultas operation/method
 */
if ($servicio->ServicioConsultaDirectorioConsultas() !== false) {
    print_r($servicio->getResult());
} else {
    print_r($servicio->getLastError());
}
/**
 * Sample call for ServicioConsultaConfiguracionConsulta operation/method
 */
if ($servicio->ServicioConsultaConfiguracionConsulta(new \StructType\TCodConsulta()) !== false) {
    print_r($servicio->getResult());
} else {
    print_r($servicio->getLastError());
}
/**
 * Sample call for ServicioEjecucionConsultaEncolumnada operation/method
 */
if ($servicio->ServicioEjecucionConsultaEncolumnada(new \StructType\TMensajeEjecucionConsulta()) !== false) {
    print_r($servicio->getResult());
} else {
    print_r($servicio->getLastError());
}
/**
 * Sample call for ServicioEjecucionConsultaAnexo operation/method
 */
if ($servicio->ServicioEjecucionConsultaAnexo(new \StructType\TMensajeEjecucionConsulta()) !== false) {
    print_r($servicio->getResult());
} else {
    print_r($servicio->getLastError());
}
/**
 * Sample call for ServicioEjecucionConsultaPrograma operation/method
 */
if ($servicio->ServicioEjecucionConsultaPrograma(new \StructType\TMensajeEjecucionConsulta()) !== false) {
    print_r($servicio->getResult());
} else {
    print_r($servicio->getLastError());
}
