<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tTipoTransaccion StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo y Subtipo de transacción
 * @subpackage Structs
 */
class TTipoTransaccion extends AbstractStructBase
{
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - documentation: Tipo de transacción
     * - use: required
     * @var string
     */
    public $tipo;
    /**
     * The subTipo
     * Meta information extracted from the WSDL
     * - documentation: Subtipo de transacción
     * - use: required
     * @var string
     */
    public $subTipo;
    /**
     * Constructor method for tTipoTransaccion
     * @uses TTipoTransaccion::setTipo()
     * @uses TTipoTransaccion::setSubTipo()
     * @param string $tipo
     * @param string $subTipo
     */
    public function __construct($tipo = null, $subTipo = null)
    {
        $this
            ->setTipo($tipo)
            ->setSubTipo($subTipo);
    }
    /**
     * Get tipo value
     * @return string
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @uses \EnumType\TAtrTipoTransaccion::valueIsValid()
     * @uses \EnumType\TAtrTipoTransaccion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\TTipoTransaccion
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrTipoTransaccion::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrTipoTransaccion', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\TAtrTipoTransaccion::getValidValues())), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
    /**
     * Get subTipo value
     * @return string
     */
    public function getSubTipo()
    {
        return $this->subTipo;
    }
    /**
     * Set subTipo value
     * @uses \EnumType\TAtrSubtipoTransaccion::valueIsValid()
     * @uses \EnumType\TAtrSubtipoTransaccion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subTipo
     * @return \StructType\TTipoTransaccion
     */
    public function setSubTipo($subTipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TAtrSubtipoTransaccion::valueIsValid($subTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TAtrSubtipoTransaccion', is_array($subTipo) ? implode(', ', $subTipo) : var_export($subTipo, true), implode(', ', \EnumType\TAtrSubtipoTransaccion::getValidValues())), __LINE__);
        }
        $this->subTipo = $subTipo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TTipoTransaccion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
