<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tSerieTemporalHorasAnuladas StructType
 * Meta information extracted from the WSDL
 * - documentation: Serie temporal
 * @subpackage Structs
 */
class TSerieTemporalHorasAnuladas extends AbstractStructBase
{
    /**
     * The IdSerieTemporal
     * Meta information extracted from the WSDL
     * - documentation: Identificativo de serie dentro del fichero.
     * @var \StructType\TId
     */
    public $IdSerieTemporal;
    /**
     * The Periodo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TPeriodoHorasAnuladas[]
     */
    public $Periodo;
    /**
     * Constructor method for tSerieTemporalHorasAnuladas
     * @uses TSerieTemporalHorasAnuladas::setIdSerieTemporal()
     * @uses TSerieTemporalHorasAnuladas::setPeriodo()
     * @param \StructType\TId $idSerieTemporal
     * @param \StructType\TPeriodoHorasAnuladas[] $periodo
     */
    public function __construct(\StructType\TId $idSerieTemporal = null, array $periodo = array())
    {
        $this
            ->setIdSerieTemporal($idSerieTemporal)
            ->setPeriodo($periodo);
    }
    /**
     * Get IdSerieTemporal value
     * @return \StructType\TId|null
     */
    public function getIdSerieTemporal()
    {
        return $this->IdSerieTemporal;
    }
    /**
     * Set IdSerieTemporal value
     * @param \StructType\TId $idSerieTemporal
     * @return \StructType\TSerieTemporalHorasAnuladas
     */
    public function setIdSerieTemporal(\StructType\TId $idSerieTemporal = null)
    {
        $this->IdSerieTemporal = $idSerieTemporal;
        return $this;
    }
    /**
     * Get Periodo value
     * @return \StructType\TPeriodoHorasAnuladas[]|null
     */
    public function getPeriodo()
    {
        return $this->Periodo;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriodo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriodo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodoForArrayConstraintsFromSetPeriodo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tSerieTemporalHorasAnuladasPeriodoItem) {
            // validation for constraint: itemType
            if (!$tSerieTemporalHorasAnuladasPeriodoItem instanceof \StructType\TPeriodoHorasAnuladas) {
                $invalidValues[] = is_object($tSerieTemporalHorasAnuladasPeriodoItem) ? get_class($tSerieTemporalHorasAnuladasPeriodoItem) : sprintf('%s(%s)', gettype($tSerieTemporalHorasAnuladasPeriodoItem), var_export($tSerieTemporalHorasAnuladasPeriodoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Periodo property can only contain items of type \StructType\TPeriodoHorasAnuladas, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoHorasAnuladas[] $periodo
     * @return \StructType\TSerieTemporalHorasAnuladas
     */
    public function setPeriodo(array $periodo = array())
    {
        // validation for constraint: array
        if ('' !== ($periodoArrayErrorMessage = self::validatePeriodoForArrayConstraintsFromSetPeriodo($periodo))) {
            throw new \InvalidArgumentException($periodoArrayErrorMessage, __LINE__);
        }
        $this->Periodo = $periodo;
        return $this;
    }
    /**
     * Add item to Periodo value
     * @throws \InvalidArgumentException
     * @param \StructType\TPeriodoHorasAnuladas $item
     * @return \StructType\TSerieTemporalHorasAnuladas
     */
    public function addToPeriodo(\StructType\TPeriodoHorasAnuladas $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TPeriodoHorasAnuladas) {
            throw new \InvalidArgumentException(sprintf('The Periodo property can only contain items of type \StructType\TPeriodoHorasAnuladas, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Periodo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TSerieTemporalHorasAnuladas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
