<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tRespuestaEjecucionConsultaEncolumnada StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo básico para respuesta a la ejecución de una consulta encolumnada
 * @subpackage Structs
 */
class TRespuestaEjecucionConsultaEncolumnada extends AbstractStructBase
{
    /**
     * The CodConsulta
     * Meta information extracted from the WSDL
     * - documentation: Código de Consulta
     * @var \StructType\TCodConsulta
     */
    public $CodConsulta;
    /**
     * The Parametros
     * @var \StructType\Parametros
     */
    public $Parametros;
    /**
     * The Agregados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Agregados
     */
    public $Agregados;
    /**
     * The Fila
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Fila[]
     */
    public $Fila;
    /**
     * The Respuesta
     * Meta information extracted from the WSDL
     * - documentation: Código y texto de respuesta
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TRespuesta[]
     */
    public $Respuesta;
    /**
     * Constructor method for tRespuestaEjecucionConsultaEncolumnada
     * @uses TRespuestaEjecucionConsultaEncolumnada::setCodConsulta()
     * @uses TRespuestaEjecucionConsultaEncolumnada::setParametros()
     * @uses TRespuestaEjecucionConsultaEncolumnada::setAgregados()
     * @uses TRespuestaEjecucionConsultaEncolumnada::setFila()
     * @uses TRespuestaEjecucionConsultaEncolumnada::setRespuesta()
     * @param \StructType\TCodConsulta $codConsulta
     * @param \StructType\Parametros $parametros
     * @param \StructType\Agregados $agregados
     * @param \StructType\Fila[] $fila
     * @param \StructType\TRespuesta[] $respuesta
     */
    public function __construct(\StructType\TCodConsulta $codConsulta = null, \StructType\Parametros $parametros = null, \StructType\Agregados $agregados = null, array $fila = array(), array $respuesta = array())
    {
        $this
            ->setCodConsulta($codConsulta)
            ->setParametros($parametros)
            ->setAgregados($agregados)
            ->setFila($fila)
            ->setRespuesta($respuesta);
    }
    /**
     * Get CodConsulta value
     * @return \StructType\TCodConsulta|null
     */
    public function getCodConsulta()
    {
        return $this->CodConsulta;
    }
    /**
     * Set CodConsulta value
     * @param \StructType\TCodConsulta $codConsulta
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function setCodConsulta(\StructType\TCodConsulta $codConsulta = null)
    {
        $this->CodConsulta = $codConsulta;
        return $this;
    }
    /**
     * Get Parametros value
     * @return \StructType\Parametros|null
     */
    public function getParametros()
    {
        return $this->Parametros;
    }
    /**
     * Set Parametros value
     * @param \StructType\Parametros $parametros
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function setParametros(\StructType\Parametros $parametros = null)
    {
        $this->Parametros = $parametros;
        return $this;
    }
    /**
     * Get Agregados value
     * @return \StructType\Agregados|null
     */
    public function getAgregados()
    {
        return $this->Agregados;
    }
    /**
     * Set Agregados value
     * @param \StructType\Agregados $agregados
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function setAgregados(\StructType\Agregados $agregados = null)
    {
        $this->Agregados = $agregados;
        return $this;
    }
    /**
     * Get Fila value
     * @return \StructType\Fila[]|null
     */
    public function getFila()
    {
        return $this->Fila;
    }
    /**
     * This method is responsible for validating the values passed to the setFila method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFila method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFilaForArrayConstraintsFromSetFila(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tRespuestaEjecucionConsultaEncolumnadaFilaItem) {
            // validation for constraint: itemType
            if (!$tRespuestaEjecucionConsultaEncolumnadaFilaItem instanceof \StructType\Fila) {
                $invalidValues[] = is_object($tRespuestaEjecucionConsultaEncolumnadaFilaItem) ? get_class($tRespuestaEjecucionConsultaEncolumnadaFilaItem) : sprintf('%s(%s)', gettype($tRespuestaEjecucionConsultaEncolumnadaFilaItem), var_export($tRespuestaEjecucionConsultaEncolumnadaFilaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fila property can only contain items of type \StructType\Fila, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fila value
     * @throws \InvalidArgumentException
     * @param \StructType\Fila[] $fila
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function setFila(array $fila = array())
    {
        // validation for constraint: array
        if ('' !== ($filaArrayErrorMessage = self::validateFilaForArrayConstraintsFromSetFila($fila))) {
            throw new \InvalidArgumentException($filaArrayErrorMessage, __LINE__);
        }
        $this->Fila = $fila;
        return $this;
    }
    /**
     * Add item to Fila value
     * @throws \InvalidArgumentException
     * @param \StructType\Fila $item
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function addToFila(\StructType\Fila $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fila) {
            throw new \InvalidArgumentException(sprintf('The Fila property can only contain items of type \StructType\Fila, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fila[] = $item;
        return $this;
    }
    /**
     * Get Respuesta value
     * @return \StructType\TRespuesta[]|null
     */
    public function getRespuesta()
    {
        return $this->Respuesta;
    }
    /**
     * This method is responsible for validating the values passed to the setRespuesta method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRespuesta method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRespuestaForArrayConstraintsFromSetRespuesta(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tRespuestaEjecucionConsultaEncolumnadaRespuestaItem) {
            // validation for constraint: itemType
            if (!$tRespuestaEjecucionConsultaEncolumnadaRespuestaItem instanceof \StructType\TRespuesta) {
                $invalidValues[] = is_object($tRespuestaEjecucionConsultaEncolumnadaRespuestaItem) ? get_class($tRespuestaEjecucionConsultaEncolumnadaRespuestaItem) : sprintf('%s(%s)', gettype($tRespuestaEjecucionConsultaEncolumnadaRespuestaItem), var_export($tRespuestaEjecucionConsultaEncolumnadaRespuestaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Respuesta property can only contain items of type \StructType\TRespuesta, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Respuesta value
     * @throws \InvalidArgumentException
     * @param \StructType\TRespuesta[] $respuesta
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function setRespuesta(array $respuesta = array())
    {
        // validation for constraint: array
        if ('' !== ($respuestaArrayErrorMessage = self::validateRespuestaForArrayConstraintsFromSetRespuesta($respuesta))) {
            throw new \InvalidArgumentException($respuestaArrayErrorMessage, __LINE__);
        }
        $this->Respuesta = $respuesta;
        return $this;
    }
    /**
     * Add item to Respuesta value
     * @throws \InvalidArgumentException
     * @param \StructType\TRespuesta $item
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public function addToRespuesta(\StructType\TRespuesta $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TRespuesta) {
            throw new \InvalidArgumentException(sprintf('The Respuesta property can only contain items of type \StructType\TRespuesta, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Respuesta[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TRespuestaEjecucionConsultaEncolumnada
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
