<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tRespuestaEjecucionConsultaAnexo StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo básico para respuesta a la ejecución de una consulta encolumnada
 * @subpackage Structs
 */
class TRespuestaEjecucionConsultaAnexo extends AbstractStructBase
{
    /**
     * The CodConsulta
     * Meta information extracted from the WSDL
     * - documentation: Código de Consulta
     * @var \StructType\TCodConsulta
     */
    public $CodConsulta;
    /**
     * The Parametros
     * @var \StructType\Parametros
     */
    public $Parametros;
    /**
     * The AtributosFicheroAnexo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AtributosFicheroAnexo
     */
    public $AtributosFicheroAnexo;
    /**
     * The Respuesta
     * Meta information extracted from the WSDL
     * - documentation: Código y texto de respuesta
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TRespuesta[]
     */
    public $Respuesta;
    /**
     * Constructor method for tRespuestaEjecucionConsultaAnexo
     * @uses TRespuestaEjecucionConsultaAnexo::setCodConsulta()
     * @uses TRespuestaEjecucionConsultaAnexo::setParametros()
     * @uses TRespuestaEjecucionConsultaAnexo::setAtributosFicheroAnexo()
     * @uses TRespuestaEjecucionConsultaAnexo::setRespuesta()
     * @param \StructType\TCodConsulta $codConsulta
     * @param \StructType\Parametros $parametros
     * @param \StructType\AtributosFicheroAnexo $atributosFicheroAnexo
     * @param \StructType\TRespuesta[] $respuesta
     */
    public function __construct(\StructType\TCodConsulta $codConsulta = null, \StructType\Parametros $parametros = null, \StructType\AtributosFicheroAnexo $atributosFicheroAnexo = null, array $respuesta = array())
    {
        $this
            ->setCodConsulta($codConsulta)
            ->setParametros($parametros)
            ->setAtributosFicheroAnexo($atributosFicheroAnexo)
            ->setRespuesta($respuesta);
    }
    /**
     * Get CodConsulta value
     * @return \StructType\TCodConsulta|null
     */
    public function getCodConsulta()
    {
        return $this->CodConsulta;
    }
    /**
     * Set CodConsulta value
     * @param \StructType\TCodConsulta $codConsulta
     * @return \StructType\TRespuestaEjecucionConsultaAnexo
     */
    public function setCodConsulta(\StructType\TCodConsulta $codConsulta = null)
    {
        $this->CodConsulta = $codConsulta;
        return $this;
    }
    /**
     * Get Parametros value
     * @return \StructType\Parametros|null
     */
    public function getParametros()
    {
        return $this->Parametros;
    }
    /**
     * Set Parametros value
     * @param \StructType\Parametros $parametros
     * @return \StructType\TRespuestaEjecucionConsultaAnexo
     */
    public function setParametros(\StructType\Parametros $parametros = null)
    {
        $this->Parametros = $parametros;
        return $this;
    }
    /**
     * Get AtributosFicheroAnexo value
     * @return \StructType\AtributosFicheroAnexo|null
     */
    public function getAtributosFicheroAnexo()
    {
        return $this->AtributosFicheroAnexo;
    }
    /**
     * Set AtributosFicheroAnexo value
     * @param \StructType\AtributosFicheroAnexo $atributosFicheroAnexo
     * @return \StructType\TRespuestaEjecucionConsultaAnexo
     */
    public function setAtributosFicheroAnexo(\StructType\AtributosFicheroAnexo $atributosFicheroAnexo = null)
    {
        $this->AtributosFicheroAnexo = $atributosFicheroAnexo;
        return $this;
    }
    /**
     * Get Respuesta value
     * @return \StructType\TRespuesta[]|null
     */
    public function getRespuesta()
    {
        return $this->Respuesta;
    }
    /**
     * This method is responsible for validating the values passed to the setRespuesta method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRespuesta method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRespuestaForArrayConstraintsFromSetRespuesta(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tRespuestaEjecucionConsultaAnexoRespuestaItem) {
            // validation for constraint: itemType
            if (!$tRespuestaEjecucionConsultaAnexoRespuestaItem instanceof \StructType\TRespuesta) {
                $invalidValues[] = is_object($tRespuestaEjecucionConsultaAnexoRespuestaItem) ? get_class($tRespuestaEjecucionConsultaAnexoRespuestaItem) : sprintf('%s(%s)', gettype($tRespuestaEjecucionConsultaAnexoRespuestaItem), var_export($tRespuestaEjecucionConsultaAnexoRespuestaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Respuesta property can only contain items of type \StructType\TRespuesta, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Respuesta value
     * @throws \InvalidArgumentException
     * @param \StructType\TRespuesta[] $respuesta
     * @return \StructType\TRespuestaEjecucionConsultaAnexo
     */
    public function setRespuesta(array $respuesta = array())
    {
        // validation for constraint: array
        if ('' !== ($respuestaArrayErrorMessage = self::validateRespuestaForArrayConstraintsFromSetRespuesta($respuesta))) {
            throw new \InvalidArgumentException($respuestaArrayErrorMessage, __LINE__);
        }
        $this->Respuesta = $respuesta;
        return $this;
    }
    /**
     * Add item to Respuesta value
     * @throws \InvalidArgumentException
     * @param \StructType\TRespuesta $item
     * @return \StructType\TRespuestaEjecucionConsultaAnexo
     */
    public function addToRespuesta(\StructType\TRespuesta $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TRespuesta) {
            throw new \InvalidArgumentException(sprintf('The Respuesta property can only contain items of type \StructType\TRespuesta, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Respuesta[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TRespuestaEjecucionConsultaAnexo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
