<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tIdRemitente StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo que identifica un remitente, como código de agente, etc.
 * @subpackage Structs
 */
class TIdRemitente extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * - pattern: (\p{Lu}|\p{N}|\p{Pd}|\p{Pc}|\p{Zs}){1,5}
     * - use: required
     * @var string
     */
    public $v;
    /**
     * Constructor method for tIdRemitente
     * @uses TIdRemitente::setV()
     * @param string $v
     */
    public function __construct($v = null)
    {
        $this
            ->setV($v);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param string $v
     * @return \StructType\TIdRemitente
     */
    public function setV($v = null)
    {
        // validation for constraint: string
        if (!is_null($v) && !is_string($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($v) && mb_strlen($v) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($v)), __LINE__);
        }
        // validation for constraint: pattern((\p{Lu}|\p{N}|\p{Pd}|\p{Pc}|\p{Zs}){1,5})
        if (!is_null($v) && !preg_match('/(\\p{Lu}|\\p{N}|\\p{Pd}|\\p{Pc}|\\p{Zs}){1,5}/', $v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\p{Lu}|\p{N}|\p{Pd}|\p{Pc}|\p{Zs}){1,5}', var_export($v, true)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TIdRemitente
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
