<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tCodTransaccion StructType
 * Meta information extracted from the WSDL
 * - documentation: Código y versión de una transacción (oferta, ejecución, declaración)
 * @subpackage Structs
 */
class TCodTransaccion extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - maxInclusive: 9999999999
     * - minInclusive: 0
     * - totalDigits: 10
     * - use: required
     * @var int
     */
    public $codigo;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - maxInclusive: 999
     * - minInclusive: 0
     * - totalDigits: 3
     * - use: optional
     * @var int
     */
    public $version;
    /**
     * Constructor method for tCodTransaccion
     * @uses TCodTransaccion::setCodigo()
     * @uses TCodTransaccion::setVersion()
     * @param int $codigo
     * @param int $version
     */
    public function __construct($codigo = null, $version = null)
    {
        $this
            ->setCodigo($codigo)
            ->setVersion($version);
    }
    /**
     * Get codigo value
     * @return int
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\TCodTransaccion
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999)
        if (!is_null($codigo) && $codigo > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999', var_export($codigo, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($codigo) && $codigo < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($codigo, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($codigo) && mb_strlen(preg_replace('/(\D)/', '', $codigo)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($codigo, true), mb_strlen(preg_replace('/(\D)/', '', $codigo))), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\TCodTransaccion
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($version) && $version > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($version, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($version) && $version < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($version, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($version) && mb_strlen(preg_replace('/(\D)/', '', $version)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($version, true), mb_strlen(preg_replace('/(\D)/', '', $version))), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TCodTransaccion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
