<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tCantidadSinMax StructType
 * Meta information extracted from the WSDL
 * - documentation: Cantidad de energía (sin maximo)
 * @subpackage Structs
 */
class TCantidadSinMax extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $v;
    /**
     * Constructor method for tCantidadSinMax
     * @uses TCantidadSinMax::setV()
     * @param float $v
     */
    public function __construct($v = null)
    {
        $this
            ->setV($v);
    }
    /**
     * Get v value
     * @return float
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param float $v
     * @return \StructType\TCantidadSinMax
     */
    public function setV($v = null)
    {
        // validation for constraint: float
        if (!is_null($v) && !(is_float($v) || is_numeric($v))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($v) && mb_strlen(mb_substr($v, mb_strpos($v, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($v, true), mb_strlen(mb_substr($v, mb_strpos($v, '.') + 1))), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TCantidadSinMax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
