<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tAnotacionesEmpresa StructType
 * Meta information extracted from the WSDL
 * - documentation: Describe las anotaciones por empresa
 * @subpackage Structs
 */
class TAnotacionesEmpresa extends AbstractStructBase
{
    /**
     * The IdEmpresa
     * Meta information extracted from the WSDL
     * - documentation: Identificativo de Empresa
     * @var \StructType\TIdEmpresa
     */
    public $IdEmpresa;
    /**
     * The SerieTemporal
     * Meta information extracted from the WSDL
     * - documentation: Anotaciones de las unidades de una empresa, por producto
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TSerieTemporalAnotaciones[]
     */
    public $SerieTemporal;
    /**
     * Constructor method for tAnotacionesEmpresa
     * @uses TAnotacionesEmpresa::setIdEmpresa()
     * @uses TAnotacionesEmpresa::setSerieTemporal()
     * @param \StructType\TIdEmpresa $idEmpresa
     * @param \StructType\TSerieTemporalAnotaciones[] $serieTemporal
     */
    public function __construct(\StructType\TIdEmpresa $idEmpresa = null, array $serieTemporal = array())
    {
        $this
            ->setIdEmpresa($idEmpresa)
            ->setSerieTemporal($serieTemporal);
    }
    /**
     * Get IdEmpresa value
     * @return \StructType\TIdEmpresa|null
     */
    public function getIdEmpresa()
    {
        return $this->IdEmpresa;
    }
    /**
     * Set IdEmpresa value
     * @param \StructType\TIdEmpresa $idEmpresa
     * @return \StructType\TAnotacionesEmpresa
     */
    public function setIdEmpresa(\StructType\TIdEmpresa $idEmpresa = null)
    {
        $this->IdEmpresa = $idEmpresa;
        return $this;
    }
    /**
     * Get SerieTemporal value
     * @return \StructType\TSerieTemporalAnotaciones[]|null
     */
    public function getSerieTemporal()
    {
        return $this->SerieTemporal;
    }
    /**
     * This method is responsible for validating the values passed to the setSerieTemporal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerieTemporal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSerieTemporalForArrayConstraintsFromSetSerieTemporal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tAnotacionesEmpresaSerieTemporalItem) {
            // validation for constraint: itemType
            if (!$tAnotacionesEmpresaSerieTemporalItem instanceof \StructType\TSerieTemporalAnotaciones) {
                $invalidValues[] = is_object($tAnotacionesEmpresaSerieTemporalItem) ? get_class($tAnotacionesEmpresaSerieTemporalItem) : sprintf('%s(%s)', gettype($tAnotacionesEmpresaSerieTemporalItem), var_export($tAnotacionesEmpresaSerieTemporalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SerieTemporal property can only contain items of type \StructType\TSerieTemporalAnotaciones, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SerieTemporal value
     * @throws \InvalidArgumentException
     * @param \StructType\TSerieTemporalAnotaciones[] $serieTemporal
     * @return \StructType\TAnotacionesEmpresa
     */
    public function setSerieTemporal(array $serieTemporal = array())
    {
        // validation for constraint: array
        if ('' !== ($serieTemporalArrayErrorMessage = self::validateSerieTemporalForArrayConstraintsFromSetSerieTemporal($serieTemporal))) {
            throw new \InvalidArgumentException($serieTemporalArrayErrorMessage, __LINE__);
        }
        $this->SerieTemporal = $serieTemporal;
        return $this;
    }
    /**
     * Add item to SerieTemporal value
     * @throws \InvalidArgumentException
     * @param \StructType\TSerieTemporalAnotaciones $item
     * @return \StructType\TAnotacionesEmpresa
     */
    public function addToSerieTemporal(\StructType\TSerieTemporalAnotaciones $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TSerieTemporalAnotaciones) {
            throw new \InvalidArgumentException(sprintf('The SerieTemporal property can only contain items of type \StructType\TSerieTemporalAnotaciones, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SerieTemporal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAnotacionesEmpresa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
