<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tAgente StructType
 * Meta information extracted from the WSDL
 * - documentation: Identificación del Agente
 * @subpackage Structs
 */
class TAgente extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * - use: required
     * @var string
     */
    public $v;
    /**
     * The desc
     * Meta information extracted from the WSDL
     * - documentation: Descripción del agente
     * @var string
     */
    public $desc;
    /**
     * The CIF
     * Meta information extracted from the WSDL
     * - documentation: CIF del agente
     * @var string
     */
    public $CIF;
    /**
     * Constructor method for tAgente
     * @uses TAgente::setV()
     * @uses TAgente::setDesc()
     * @uses TAgente::setCIF()
     * @param string $v
     * @param string $desc
     * @param string $cIF
     */
    public function __construct($v = null, $desc = null, $cIF = null)
    {
        $this
            ->setV($v)
            ->setDesc($desc)
            ->setCIF($cIF);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param string $v
     * @return \StructType\TAgente
     */
    public function setV($v = null)
    {
        // validation for constraint: string
        if (!is_null($v) && !is_string($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($v) && mb_strlen($v) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($v)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\TAgente
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get CIF value
     * @return string|null
     */
    public function getCIF()
    {
        return $this->CIF;
    }
    /**
     * Set CIF value
     * @param string $cIF
     * @return \StructType\TAgente
     */
    public function setCIF($cIF = null)
    {
        // validation for constraint: string
        if (!is_null($cIF) && !is_string($cIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIF, true), gettype($cIF)), __LINE__);
        }
        $this->CIF = $cIF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TAgente
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
