<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seccion StructType
 * Meta information extracted from the WSDL
 * - documentation: Sección o apartado al que pertenecen las consultas | Sección o Apartado al que pertenece la consulta
 * @subpackage Structs
 */
class Seccion extends AbstractStructBase
{
    /**
     * The v
     * Meta information extracted from the WSDL
     * - documentation: Valor
     * - base: xsd:string
     * - maxLength: 255
     * - use: required
     * @var string
     */
    public $v;
    /**
     * The Consultas
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: om:Consultas
     * @var \StructType\Consultas[]
     */
    public $Consultas;
    /**
     * Constructor method for Seccion
     * @uses Seccion::setV()
     * @uses Seccion::setConsultas()
     * @param string $v
     * @param \StructType\Consultas[] $consultas
     */
    public function __construct($v = null, array $consultas = array())
    {
        $this
            ->setV($v)
            ->setConsultas($consultas);
    }
    /**
     * Get v value
     * @return string
     */
    public function getV()
    {
        return $this->v;
    }
    /**
     * Set v value
     * @param string $v
     * @return \StructType\Seccion
     */
    public function setV($v = null)
    {
        // validation for constraint: string
        if (!is_null($v) && !is_string($v)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v, true), gettype($v)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($v) && mb_strlen($v) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($v)), __LINE__);
        }
        $this->v = $v;
        return $this;
    }
    /**
     * Get Consultas value
     * @return \StructType\Consultas[]|null
     */
    public function getConsultas()
    {
        return $this->Consultas;
    }
    /**
     * This method is responsible for validating the values passed to the setConsultas method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsultas method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsultasForArrayConstraintsFromSetConsultas(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seccionConsultasItem) {
            // validation for constraint: itemType
            if (!$seccionConsultasItem instanceof \StructType\Consultas) {
                $invalidValues[] = is_object($seccionConsultasItem) ? get_class($seccionConsultasItem) : sprintf('%s(%s)', gettype($seccionConsultasItem), var_export($seccionConsultasItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Consultas property can only contain items of type \StructType\Consultas, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Consultas value
     * @throws \InvalidArgumentException
     * @param \StructType\Consultas[] $consultas
     * @return \StructType\Seccion
     */
    public function setConsultas(array $consultas = array())
    {
        // validation for constraint: array
        if ('' !== ($consultasArrayErrorMessage = self::validateConsultasForArrayConstraintsFromSetConsultas($consultas))) {
            throw new \InvalidArgumentException($consultasArrayErrorMessage, __LINE__);
        }
        $this->Consultas = $consultas;
        return $this;
    }
    /**
     * Add item to Consultas value
     * @throws \InvalidArgumentException
     * @param \StructType\Consultas $item
     * @return \StructType\Seccion
     */
    public function addToConsultas(\StructType\Consultas $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Consultas) {
            throw new \InvalidArgumentException(sprintf('The Consultas property can only contain items of type \StructType\Consultas, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Consultas[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Seccion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
