<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Servicio ServiceType
 * @subpackage Services
 */
class Servicio extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * ServicioConsultaDirectorioConsultas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\RespuestaDirectorioConsultasResponse|bool
     */
    public function ServicioConsultaDirectorioConsultas()
    {
        try {
            $this->setResult($this->getSoapClient()->ServicioConsultaDirectorioConsultas());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ServicioConsultaConfiguracionConsulta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TCodConsulta $codConsulta
     * @return \StructType\RespuestaConfiguracionConsultaResponse|bool
     */
    public function ServicioConsultaConfiguracionConsulta(\StructType\TCodConsulta $codConsulta)
    {
        try {
            $this->setResult($this->getSoapClient()->ServicioConsultaConfiguracionConsulta($codConsulta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ServicioEjecucionConsultaEncolumnada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TMensajeEjecucionConsulta $mensajeEjecucionConsulta
     * @return \StructType\RespuestaEjecucionConsultaEncolumnadaResponse|bool
     */
    public function ServicioEjecucionConsultaEncolumnada(\StructType\TMensajeEjecucionConsulta $mensajeEjecucionConsulta)
    {
        try {
            $this->setResult($this->getSoapClient()->ServicioEjecucionConsultaEncolumnada($mensajeEjecucionConsulta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServicioEjecucionConsultaAnexo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TMensajeEjecucionConsulta $mensajeEjecucionConsulta
     * @return \StructType\TRespuestaEjecucionConsultaAnexo|bool
     */
    public function ServicioEjecucionConsultaAnexo(\StructType\TMensajeEjecucionConsulta $mensajeEjecucionConsulta)
    {
        try {
            $this->setResult($this->getSoapClient()->ServicioEjecucionConsultaAnexo($mensajeEjecucionConsulta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ServicioEjecucionConsultaPrograma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TMensajeEjecucionConsulta $mensajeEjecucionConsulta
     * @return \StructType\TMensajeProgramas|bool
     */
    public function ServicioEjecucionConsultaPrograma(\StructType\TMensajeEjecucionConsulta $mensajeEjecucionConsulta)
    {
        try {
            $this->setResult($this->getSoapClient()->ServicioEjecucionConsultaPrograma($mensajeEjecucionConsulta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaConfiguracionConsultaResponse|\StructType\RespuestaDirectorioConsultasResponse|\StructType\RespuestaEjecucionConsultaEncolumnadaResponse|\StructType\TMensajeProgramas|\StructType\TRespuestaEjecucionConsultaAnexo
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
