<?php

namespace EnumType;

/**
 * This class stands for tAtrUniPrecio EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para unidad de precio
 * @subpackage Enumerations
 */
class TAtrUniPrecio
{
    /**
     * Constant for value 'cEURO/kWh'
     * Meta information extracted from the WSDL
     * - documentation: cEur/MWh
     * @return string 'cEURO/kWh'
     */
    const VALUE_C_EURO_K_WH = 'cEURO/kWh';
    /**
     * Constant for value 'cEURO/MWh'
     * @return string 'cEURO/MWh'
     */
    const VALUE_C_EURO_MWH = 'cEURO/MWh';
    /**
     * Constant for value 'EURO/MWh'
     * @return string 'EURO/MWh'
     */
    const VALUE_EURO_MWH = 'EURO/MWh';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_C_EURO_K_WH
     * @uses self::VALUE_C_EURO_MWH
     * @uses self::VALUE_EURO_MWH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_C_EURO_K_WH,
            self::VALUE_C_EURO_MWH,
            self::VALUE_EURO_MWH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
