<?php

namespace EnumType;

/**
 * This class stands for tAtrTipoConsulta EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para tipos de consultas (ENCOL, PROGR, ANEXO)
 * @subpackage Enumerations
 */
class TAtrTipoConsulta
{
    /**
     * Constant for value 'ENCOL'
     * Meta information extracted from the WSDL
     * - documentation: Consulta encolumnada
     * @return string 'ENCOL'
     */
    const VALUE_ENCOL = 'ENCOL';
    /**
     * Constant for value 'PROGR'
     * Meta information extracted from the WSDL
     * - documentation: Consulta de tipo Programa
     * @return string 'PROGR'
     */
    const VALUE_PROGR = 'PROGR';
    /**
     * Constant for value 'ANEXO'
     * Meta information extracted from the WSDL
     * - documentation: Consulta a fichero anexo
     * @return string 'ANEXO'
     */
    const VALUE_ANEXO = 'ANEXO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENCOL
     * @uses self::VALUE_PROGR
     * @uses self::VALUE_ANEXO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENCOL,
            self::VALUE_PROGR,
            self::VALUE_ANEXO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
