<?php

namespace EnumType;

/**
 * This class stands for tAtrMercado EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para tipo de mercado (MD, MI)
 * @subpackage Enumerations
 */
class TAtrMercado
{
    /**
     * Constant for value 'MD'
     * Meta information extracted from the WSDL
     * - documentation: MD: Mercado Diario
     * @return string 'MD'
     */
    const VALUE_MD = 'MD';
    /**
     * Constant for value 'MI'
     * Meta information extracted from the WSDL
     * - documentation: MI: Mercado Intradiario
     * @return string 'MI'
     */
    const VALUE_MI = 'MI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MD
     * @uses self::VALUE_MI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MD,
            self::VALUE_MI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
