<?php

namespace EnumType;

/**
 * This class stands for tAtrIdPrograma EnumType
 * Meta information extracted from the WSDL
 * - documentation: Atributo para Identificativo de Programa (PDBC, PIBC, ...)
 * @subpackage Enumerations
 */
class TAtrIdPrograma
{
    /**
     * Constant for value 'PDBC'
     * @return string 'PDBC'
     */
    const VALUE_PDBC = 'PDBC';
    /**
     * Constant for value 'PDBF'
     * @return string 'PDBF'
     */
    const VALUE_PDBF = 'PDBF';
    /**
     * Constant for value 'PIBCI'
     * @return string 'PIBCI'
     */
    const VALUE_PIBCI = 'PIBCI';
    /**
     * Constant for value 'PIBCA'
     * @return string 'PIBCA'
     */
    const VALUE_PIBCA = 'PIBCA';
    /**
     * Constant for value 'PHF'
     * @return string 'PHF'
     */
    const VALUE_PHF = 'PHF';
    /**
     * Constant for value 'PDVD'
     * @return string 'PDVD'
     */
    const VALUE_PDVD = 'PDVD';
    /**
     * Constant for value 'PDVP'
     * @return string 'PDVP'
     */
    const VALUE_PDVP = 'PDVP';
    /**
     * Constant for value 'DESGLOSERE'
     * @return string 'DESGLOSERE'
     */
    const VALUE_DESGLOSERE = 'DESGLOSERE';
    /**
     * Constant for value 'DESGLOSEREINTRA'
     * @return string 'DESGLOSEREINTRA'
     */
    const VALUE_DESGLOSEREINTRA = 'DESGLOSEREINTRA';
    /**
     * Constant for value 'DESAGRERE'
     * @return string 'DESAGRERE'
     */
    const VALUE_DESAGRERE = 'DESAGRERE';
    /**
     * Constant for value 'DESAGREREI'
     * @return string 'DESAGREREI'
     */
    const VALUE_DESAGREREI = 'DESAGREREI';
    /**
     * Constant for value 'POSICIONESMP'
     * @return string 'POSICIONESMP'
     */
    const VALUE_POSICIONESMP = 'POSICIONESMP';
    /**
     * Constant for value 'PDBCE'
     * @return string 'PDBCE'
     */
    const VALUE_PDBCE = 'PDBCE';
    /**
     * Constant for value 'PIBCIE'
     * @return string 'PIBCIE'
     */
    const VALUE_PIBCIE = 'PIBCIE';
    /**
     * Constant for value 'EACB'
     * @return string 'EACB'
     */
    const VALUE_EACB = 'EACB';
    /**
     * Constant for value 'EACBI'
     * @return string 'EACBI'
     */
    const VALUE_EACBI = 'EACBI';
    /**
     * Constant for value 'EAUDI'
     * @return string 'EAUDI'
     */
    const VALUE_EAUDI = 'EAUDI';
    /**
     * Constant for value 'CAPACIDADNOMINADA'
     * @return string 'CAPACIDADNOMINADA'
     */
    const VALUE_CAPACIDADNOMINADA = 'CAPACIDADNOMINADA';
    /**
     * Constant for value 'CAPACIDADAUTORIZADAD'
     * @return string 'CAPACIDADAUTORIZADAD'
     */
    const VALUE_CAPACIDADAUTORIZADAD = 'CAPACIDADAUTORIZADAD';
    /**
     * Constant for value 'CAPACIDADAUTORIZADAI'
     * @return string 'CAPACIDADAUTORIZADAI'
     */
    const VALUE_CAPACIDADAUTORIZADAI = 'CAPACIDADAUTORIZADAI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PDBC
     * @uses self::VALUE_PDBF
     * @uses self::VALUE_PIBCI
     * @uses self::VALUE_PIBCA
     * @uses self::VALUE_PHF
     * @uses self::VALUE_PDVD
     * @uses self::VALUE_PDVP
     * @uses self::VALUE_DESGLOSERE
     * @uses self::VALUE_DESGLOSEREINTRA
     * @uses self::VALUE_DESAGRERE
     * @uses self::VALUE_DESAGREREI
     * @uses self::VALUE_POSICIONESMP
     * @uses self::VALUE_PDBCE
     * @uses self::VALUE_PIBCIE
     * @uses self::VALUE_EACB
     * @uses self::VALUE_EACBI
     * @uses self::VALUE_EAUDI
     * @uses self::VALUE_CAPACIDADNOMINADA
     * @uses self::VALUE_CAPACIDADAUTORIZADAD
     * @uses self::VALUE_CAPACIDADAUTORIZADAI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PDBC,
            self::VALUE_PDBF,
            self::VALUE_PIBCI,
            self::VALUE_PIBCA,
            self::VALUE_PHF,
            self::VALUE_PDVD,
            self::VALUE_PDVP,
            self::VALUE_DESGLOSERE,
            self::VALUE_DESGLOSEREINTRA,
            self::VALUE_DESAGRERE,
            self::VALUE_DESAGREREI,
            self::VALUE_POSICIONESMP,
            self::VALUE_PDBCE,
            self::VALUE_PIBCIE,
            self::VALUE_EACB,
            self::VALUE_EACBI,
            self::VALUE_EAUDI,
            self::VALUE_CAPACIDADNOMINADA,
            self::VALUE_CAPACIDADAUTORIZADAD,
            self::VALUE_CAPACIDADAUTORIZADAI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
