<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkGenerateLabelRequest StructType
 * @subpackage Structs
 */
class CheckGenerateLabelRequest extends AbstractStructBase
{
    /**
     * The contractNumber
     * @var string
     */
    public $contractNumber;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The outputFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OutputFormat
     */
    public $outputFormat;
    /**
     * The letter
     * @var \StructType\Letter
     */
    public $letter;
    /**
     * The fields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fields
     */
    public $fields;
    /**
     * Constructor method for checkGenerateLabelRequest
     * @uses CheckGenerateLabelRequest::setContractNumber()
     * @uses CheckGenerateLabelRequest::setPassword()
     * @uses CheckGenerateLabelRequest::setOutputFormat()
     * @uses CheckGenerateLabelRequest::setLetter()
     * @uses CheckGenerateLabelRequest::setFields()
     * @param string $contractNumber
     * @param string $password
     * @param \StructType\OutputFormat $outputFormat
     * @param \StructType\Letter $letter
     * @param \StructType\Fields $fields
     */
    public function __construct($contractNumber = null, $password = null, \StructType\OutputFormat $outputFormat = null, \StructType\Letter $letter = null, \StructType\Fields $fields = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setPassword($password)
            ->setOutputFormat($outputFormat)
            ->setLetter($letter)
            ->setFields($fields);
    }
    /**
     * Get contractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->contractNumber;
    }
    /**
     * Set contractNumber value
     * @param string $contractNumber
     * @return \StructType\CheckGenerateLabelRequest
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        $this->contractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\CheckGenerateLabelRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get outputFormat value
     * @return \StructType\OutputFormat|null
     */
    public function getOutputFormat()
    {
        return $this->outputFormat;
    }
    /**
     * Set outputFormat value
     * @param \StructType\OutputFormat $outputFormat
     * @return \StructType\CheckGenerateLabelRequest
     */
    public function setOutputFormat(\StructType\OutputFormat $outputFormat = null)
    {
        $this->outputFormat = $outputFormat;
        return $this;
    }
    /**
     * Get letter value
     * @return \StructType\Letter|null
     */
    public function getLetter()
    {
        return $this->letter;
    }
    /**
     * Set letter value
     * @param \StructType\Letter $letter
     * @return \StructType\CheckGenerateLabelRequest
     */
    public function setLetter(\StructType\Letter $letter = null)
    {
        $this->letter = $letter;
        return $this;
    }
    /**
     * Get fields value
     * @return \StructType\Fields|null
     */
    public function getFields()
    {
        return $this->fields;
    }
    /**
     * Set fields value
     * @param \StructType\Fields $fields
     * @return \StructType\CheckGenerateLabelRequest
     */
    public function setFields(\StructType\Fields $fields = null)
    {
        $this->fields = $fields;
        return $this;
    }
}
