<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for typeLetter StructType
 * @subpackage Structs
 */
class TypeLetter extends AbstractStructBase
{
    /**
     * The service
     * @var \StructType\Service
     */
    public $service;
    /**
     * The parcel
     * @var \StructType\Parcel
     */
    public $parcel;
    /**
     * The customsDeclarations
     * @var \StructType\CustomsDeclarations
     */
    public $customsDeclarations;
    /**
     * The sender
     * @var \StructType\Sender
     */
    public $sender;
    /**
     * The addressee
     * @var \StructType\Addressee
     */
    public $addressee;
    /**
     * The codSenderAddress
     * @var \StructType\TypeAdresse
     */
    public $codSenderAddress;
    /**
     * The uploadDocument
     * @var \StructType\UploadDocument
     */
    public $uploadDocument;
    /**
     * Constructor method for typeLetter
     * @uses TypeLetter::setService()
     * @uses TypeLetter::setParcel()
     * @uses TypeLetter::setCustomsDeclarations()
     * @uses TypeLetter::setSender()
     * @uses TypeLetter::setAddressee()
     * @uses TypeLetter::setCodSenderAddress()
     * @uses TypeLetter::setUploadDocument()
     * @param \StructType\Service $service
     * @param \StructType\Parcel $parcel
     * @param \StructType\CustomsDeclarations $customsDeclarations
     * @param \StructType\Sender $sender
     * @param \StructType\Addressee $addressee
     * @param \StructType\TypeAdresse $codSenderAddress
     * @param \StructType\UploadDocument $uploadDocument
     */
    public function __construct(\StructType\Service $service = null, \StructType\Parcel $parcel = null, \StructType\CustomsDeclarations $customsDeclarations = null, \StructType\Sender $sender = null, \StructType\Addressee $addressee = null, \StructType\TypeAdresse $codSenderAddress = null, \StructType\UploadDocument $uploadDocument = null)
    {
        $this
            ->setService($service)
            ->setParcel($parcel)
            ->setCustomsDeclarations($customsDeclarations)
            ->setSender($sender)
            ->setAddressee($addressee)
            ->setCodSenderAddress($codSenderAddress)
            ->setUploadDocument($uploadDocument);
    }
    /**
     * Get service value
     * @return \StructType\Service|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param \StructType\Service $service
     * @return \StructType\TypeLetter
     */
    public function setService(\StructType\Service $service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get parcel value
     * @return \StructType\Parcel|null
     */
    public function getParcel()
    {
        return $this->parcel;
    }
    /**
     * Set parcel value
     * @param \StructType\Parcel $parcel
     * @return \StructType\TypeLetter
     */
    public function setParcel(\StructType\Parcel $parcel = null)
    {
        $this->parcel = $parcel;
        return $this;
    }
    /**
     * Get customsDeclarations value
     * @return \StructType\CustomsDeclarations|null
     */
    public function getCustomsDeclarations()
    {
        return $this->customsDeclarations;
    }
    /**
     * Set customsDeclarations value
     * @param \StructType\CustomsDeclarations $customsDeclarations
     * @return \StructType\TypeLetter
     */
    public function setCustomsDeclarations(\StructType\CustomsDeclarations $customsDeclarations = null)
    {
        $this->customsDeclarations = $customsDeclarations;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\Sender|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \StructType\Sender $sender
     * @return \StructType\TypeLetter
     */
    public function setSender(\StructType\Sender $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get addressee value
     * @return \StructType\Addressee|null
     */
    public function getAddressee()
    {
        return $this->addressee;
    }
    /**
     * Set addressee value
     * @param \StructType\Addressee $addressee
     * @return \StructType\TypeLetter
     */
    public function setAddressee(\StructType\Addressee $addressee = null)
    {
        $this->addressee = $addressee;
        return $this;
    }
    /**
     * Get codSenderAddress value
     * @return \StructType\TypeAdresse|null
     */
    public function getCodSenderAddress()
    {
        return $this->codSenderAddress;
    }
    /**
     * Set codSenderAddress value
     * @param \StructType\TypeAdresse $codSenderAddress
     * @return \StructType\TypeLetter
     */
    public function setCodSenderAddress(\StructType\TypeAdresse $codSenderAddress = null)
    {
        $this->codSenderAddress = $codSenderAddress;
        return $this;
    }
    /**
     * Get uploadDocument value
     * @return \StructType\UploadDocument|null
     */
    public function getUploadDocument()
    {
        return $this->uploadDocument;
    }
    /**
     * Set uploadDocument value
     * @param \StructType\UploadDocument $uploadDocument
     * @return \StructType\TypeLetter
     */
    public function setUploadDocument(\StructType\UploadDocument $uploadDocument = null)
    {
        $this->uploadDocument = $uploadDocument;
        return $this;
    }
}
