<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for letter StructType
 * @subpackage Structs
 */
class Letter extends AbstractStructBase
{
    /**
     * The service
     * @var \StructType\Service
     */
    public $service;
    /**
     * The parcel
     * @var \StructType\Parcel
     */
    public $parcel;
    /**
     * The customsDeclarations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomsDeclarations
     */
    public $customsDeclarations;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sender
     */
    public $sender;
    /**
     * The addressee
     * @var \StructType\Addressee
     */
    public $addressee;
    /**
     * The codSenderAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CodSenderAddress
     */
    public $codSenderAddress;
    /**
     * The uploadDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UploadDocument
     */
    public $uploadDocument;
    /**
     * Constructor method for letter
     * @uses Letter::setService()
     * @uses Letter::setParcel()
     * @uses Letter::setCustomsDeclarations()
     * @uses Letter::setSender()
     * @uses Letter::setAddressee()
     * @uses Letter::setCodSenderAddress()
     * @uses Letter::setUploadDocument()
     * @param \StructType\Service $service
     * @param \StructType\Parcel $parcel
     * @param \StructType\CustomsDeclarations $customsDeclarations
     * @param \StructType\Sender $sender
     * @param \StructType\Addressee $addressee
     * @param \StructType\CodSenderAddress $codSenderAddress
     * @param \StructType\UploadDocument $uploadDocument
     */
    public function __construct(\StructType\Service $service = null, \StructType\Parcel $parcel = null, \StructType\CustomsDeclarations $customsDeclarations = null, \StructType\Sender $sender = null, \StructType\Addressee $addressee = null, \StructType\CodSenderAddress $codSenderAddress = null, \StructType\UploadDocument $uploadDocument = null)
    {
        $this
            ->setService($service)
            ->setParcel($parcel)
            ->setCustomsDeclarations($customsDeclarations)
            ->setSender($sender)
            ->setAddressee($addressee)
            ->setCodSenderAddress($codSenderAddress)
            ->setUploadDocument($uploadDocument);
    }
    /**
     * Get service value
     * @return \StructType\Service|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param \StructType\Service $service
     * @return \StructType\Letter
     */
    public function setService(\StructType\Service $service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get parcel value
     * @return \StructType\Parcel|null
     */
    public function getParcel()
    {
        return $this->parcel;
    }
    /**
     * Set parcel value
     * @param \StructType\Parcel $parcel
     * @return \StructType\Letter
     */
    public function setParcel(\StructType\Parcel $parcel = null)
    {
        $this->parcel = $parcel;
        return $this;
    }
    /**
     * Get customsDeclarations value
     * @return \StructType\CustomsDeclarations|null
     */
    public function getCustomsDeclarations()
    {
        return $this->customsDeclarations;
    }
    /**
     * Set customsDeclarations value
     * @param \StructType\CustomsDeclarations $customsDeclarations
     * @return \StructType\Letter
     */
    public function setCustomsDeclarations(\StructType\CustomsDeclarations $customsDeclarations = null)
    {
        $this->customsDeclarations = $customsDeclarations;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\Sender|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \StructType\Sender $sender
     * @return \StructType\Letter
     */
    public function setSender(\StructType\Sender $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get addressee value
     * @return \StructType\Addressee|null
     */
    public function getAddressee()
    {
        return $this->addressee;
    }
    /**
     * Set addressee value
     * @param \StructType\Addressee $addressee
     * @return \StructType\Letter
     */
    public function setAddressee(\StructType\Addressee $addressee = null)
    {
        $this->addressee = $addressee;
        return $this;
    }
    /**
     * Get codSenderAddress value
     * @return \StructType\CodSenderAddress|null
     */
    public function getCodSenderAddress()
    {
        return $this->codSenderAddress;
    }
    /**
     * Set codSenderAddress value
     * @param \StructType\CodSenderAddress $codSenderAddress
     * @return \StructType\Letter
     */
    public function setCodSenderAddress(\StructType\CodSenderAddress $codSenderAddress = null)
    {
        $this->codSenderAddress = $codSenderAddress;
        return $this;
    }
    /**
     * Get uploadDocument value
     * @return \StructType\UploadDocument|null
     */
    public function getUploadDocument()
    {
        return $this->uploadDocument;
    }
    /**
     * Set uploadDocument value
     * @param \StructType\UploadDocument $uploadDocument
     * @return \StructType\Letter
     */
    public function setUploadDocument(\StructType\UploadDocument $uploadDocument = null)
    {
        $this->uploadDocument = $uploadDocument;
        return $this;
    }
}
