<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Plan ServiceType
 * @subpackage Services
 */
class Plan extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named planPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlanPickup $parameters
     * @return \StructType\PlanPickupResponse|bool
     */
    public function planPickup(\StructType\PlanPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->planPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PlanPickupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
