<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws.colissimo.fr/sls-ws/SlsServiceWS/2.0?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws.colissimo.fr/sls-ws/SlsServiceWS/2.0?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getLabel operation/method
 */
if ($get->getLabel(new \StructType\GetLabel()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductInterService operation/method
 */
if ($get->getProductInterService(new \StructType\GetProductInterService()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBordereauByNumber operation/method
 */
if ($get->getBordereauByNumber(new \StructType\GetBordereauByNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getListMailBoxPickingDates operation/method
 */
if ($get->getListMailBoxPickingDates(new \StructType\GetListMailBoxPickingDates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getListMailBoxPickingDatesService operation/method
 */
if ($get->getListMailBoxPickingDatesService(new \StructType\GetListMailBoxPickingDatesService()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductInter operation/method
 */
if ($get->getProductInter(new \StructType\GetProductInter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for generateBordereauByParcelsNumbers operation/method
 */
if ($generate->generateBordereauByParcelsNumbers(new \StructType\GenerateBordereauByParcelsNumbers()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateTokenService operation/method
 */
if ($generate->generateTokenService(new \StructType\GenerateTokenService()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateCN23 operation/method
 */
if ($generate->generateCN23(new \StructType\GenerateCN23()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateLabelService operation/method
 */
if ($generate->generateLabelService(new \StructType\GenerateLabelService()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateCN23Service operation/method
 */
if ($generate->generateCN23Service(new \StructType\GenerateCN23Service()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateLabel operation/method
 */
if ($generate->generateLabel(new \StructType\GenerateLabel()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateBordereauByParcelsNumbersService operation/method
 */
if ($generate->generateBordereauByParcelsNumbersService(new \StructType\GenerateBordereauByParcelsNumbersService()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateToken operation/method
 */
if ($generate->generateToken(new \StructType\GenerateToken()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Plan ServiceType
 */
$plan = new \ServiceType\Plan($options);
/**
 * Sample call for planPickup operation/method
 */
if ($plan->planPickup(new \StructType\PlanPickup()) !== false) {
    print_r($plan->getResult());
} else {
    print_r($plan->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkGenerateLabel operation/method
 */
if ($check->checkGenerateLabel(new \StructType\CheckGenerateLabel()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
